/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityValue;

public class BrowserPreferences {
    private final String prefix;

    private BrowserPreferences(String prefix) {
        this.prefix = prefix;
    }

    public static BrowserPreferences startingWith(String prefix) {
        return new BrowserPreferences(prefix);
    }

    public Map<String, Object> from(EnvironmentVariables environmentVariables) {
        Properties chromePrefs = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getPropertiesWithPrefix(this.prefix);
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        for (String propertyName : chromePrefs.stringPropertyNames()) {
            String unprefixedPropertyName = this.unprefixed(this.prefix, propertyName);
            Object propertyValue = CapabilityValue.asObject(chromePrefs.getProperty(propertyName));
            preferences.put(unprefixedPropertyName, propertyValue);
        }
        return preferences;
    }

    private String unprefixed(String prefix, String propertyName) {
        return propertyName.replace(prefix, "");
    }
}

