/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.firefox;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.SanitisedBrowserPreferences;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.BrowserPreferences;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.firefox.FirefoxProfile;

public class FirefoxProfileEnhancer {
    private static final String FIREFOX_NETWORK_PROXY_TYPE = "network.proxy.type";
    private static final String FIREFOX_NETWORK_PROXY_HTTP = "network.proxy.http";
    private static final String FIREFOX_NETWORK_PROXY_HTTP_PORT = "network.proxy.http_port";
    private final EnvironmentVariables environmentVariables;

    public FirefoxProfileEnhancer(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void configureJavaSupport(FirefoxProfile profile) {
        boolean enableJava = ThucydidesSystemProperty.SECURITY_ENABLE_JAVA.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
        profile.setPreference("security.enable_java", (Object)enableJava);
    }

    public void allowWindowResizeFor(FirefoxProfile profile) {
        profile.setPreference("dom.disable_window_move_resize", (Object)false);
    }

    public void activateProxy(FirefoxProfile profile, String proxyUrl, String proxyPort) {
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP, (Object)proxyUrl);
        profile.setPreference(FIREFOX_NETWORK_PROXY_HTTP_PORT, (Object)NumberUtils.toInt((String)proxyPort));
        profile.setPreference(FIREFOX_NETWORK_PROXY_TYPE, (Object)1);
    }

    public void addPreferences(FirefoxProfile profile) {
        Optional preferences = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.FIREFOX_PREFERENCES);
        Optional driverOptions = EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.DRIVER_OPTIONS);
        preferences.ifPresent(prefs -> this.applyPreferences(profile, (String)prefs));
        driverOptions.ifPresent(options -> this.applyPreferences(profile, (String)options));
        this.addStructuredPreferencesTo(profile);
    }

    private void addStructuredPreferencesTo(FirefoxProfile profile) {
        Map<String, Object> preferences = FirefoxProfileEnhancer.preferencesConfiguredIn(this.environmentVariables);
        preferences.forEach((key, value) -> new PreferenceValue((String)key, value).applyTo(profile));
    }

    public static Map<String, Object> preferencesConfiguredIn(EnvironmentVariables environmentVariables) {
        Map<String, Object> preferences = BrowserPreferences.startingWith("firefox.preferences.").from(environmentVariables);
        preferences.putAll(BrowserPreferences.startingWith("firefox.preferences.").from(environmentVariables));
        return SanitisedBrowserPreferences.cleanUpPathsIn(preferences);
    }

    private void applyPreferences(FirefoxProfile profile, String preferences) {
        this.getPreferenceValuesFrom(preferences).forEach(value -> value.applyTo(profile));
    }

    private List<PreferenceValue> getPreferenceValuesFrom(String preferences) {
        List<String> arguments = this.split(Optional.ofNullable(preferences).orElse(""), this.preferenceSeparator());
        return arguments.stream().map(this::asPreferenceValue).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private String preferenceSeparator() {
        return this.environmentVariables.getProperty((Enum)ThucydidesSystemProperty.FIREFOX_PREFERENCE_SEPARATOR, ";");
    }

    private Optional<PreferenceValue> asPreferenceValue(String argument) {
        List<String> arguments = this.split(argument, "=");
        if (arguments.size() == 1) {
            String key = arguments.get(0);
            return Optional.of(new PreferenceValue(key, Boolean.TRUE));
        }
        if (arguments.size() == 2) {
            String key = arguments.get(0);
            String value = arguments.get(1);
            return Optional.of(new PreferenceValue(key, this.argumentValueOf(value)));
        }
        return Optional.empty();
    }

    private Object argumentValueOf(String value) {
        if (NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(value);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return Boolean.valueOf(value);
        }
        return value;
    }

    private List<String> split(String values, String separator) {
        return Splitter.on((String)separator).trimResults().omitEmptyStrings().splitToList((CharSequence)values);
    }

    static class PreferenceValue {
        private final String key;
        private final Object value;

        PreferenceValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        void applyTo(FirefoxProfile profile) {
            if (this.value instanceof Boolean) {
                profile.setPreference(this.key, (Object)((Boolean)this.value));
            } else if (this.value instanceof Integer) {
                profile.setPreference(this.key, (Object)((Integer)this.value));
            } else {
                profile.setPreference(this.key, (Object)this.value.toString());
            }
        }
    }
}

