/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.apache.commons.lang3.StringUtils;

public class ConfigureDriverFromTags {
    public static void forTags(List<String> tags) {
        String requestedDriver = ConfigureDriverFromTags.getDriverFrom(tags);
        String requestedDriverOptions = ConfigureDriverFromTags.getDriverOptionsFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
            ThucydidesWebDriverSupport.useDriverOptions((String)requestedDriverOptions);
        }
    }

    private static String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private static String getDriverOptionsFrom(List<String> tags) {
        String requestedDriverOptions = "";
        for (String tag : tags) {
            if (!tag.startsWith("@driver-options:")) continue;
            requestedDriverOptions = tag.substring(16);
        }
        return requestedDriverOptions;
    }

    public static void inTheCurrentTestOutcome() {
        if (StepEventBus.getParallelEventBus().isBaseStepListenerRegistered() && StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome() != null) {
            List<String> tags = StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome().getTags().stream().map(tag -> "@" + tag.toString()).collect(Collectors.toList());
            ConfigureDriverFromTags.forTags(tags);
        }
    }
}

