/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.SingleRunTestStatistics;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResults;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.util.BigDecimalAverageCollector;
import net.thucydides.core.util.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRunTestStatistics
implements TestStatistics {
    private final List<TestScenarioResults> results = Lists.newArrayList();
    static Logger LOGGER = LoggerFactory.getLogger(MultiRunTestStatistics.class);

    public static MultiRunTestStatistics fromRelativePath(String basePath) {
        MultiRunTestStatistics multiRunTestStatistics = new MultiRunTestStatistics();
        try {
            Path resultsPath;
            URI uri = MultiRunTestStatistics.class.getResource(basePath).toURI();
            LOGGER.info("Loading results from {}", (Object)uri);
            if (uri.getScheme().equals("jar")) {
                FileSystem fileSystem;
                try {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                catch (FileSystemAlreadyExistsException e) {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                resultsPath = fileSystem.getPath(basePath, new String[0]);
            } else {
                resultsPath = Paths.get(uri);
            }
            Files.walk(resultsPath, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(file -> {
                LOGGER.debug("Aggregating results from {}", (Object)file.getFileName());
                multiRunTestStatistics.addStatistics(SingleRunTestStatistics.fromFileName(basePath + "/" + file.getFileName()));
            });
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("could not open scenario results from %s", basePath), e);
        }
        return multiRunTestStatistics;
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.records().stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseGet(() -> this.average(feature, scenario));
    }

    @Override
    public List<TestScenarioResult> records() {
        return this.results.stream().map(TestScenarioResults::average).collect(Collectors.toList());
    }

    private void addStatistics(TestStatistics statistics) {
        statistics.records().forEach(record -> {
            Optional<TestScenarioResults> existingResult = this.results.stream().filter(existing -> existing.scenarioKey.equals(record.scenarioKey)).findFirst();
            if (existingResult.isPresent()) {
                existingResult.get().addDuration(record.duration);
            } else {
                this.results.add(TestScenarioResults.create(record));
            }
        });
    }

    private BigDecimal averageDuration() {
        return this.records().stream().map(TestScenarioResult::duration).collect(BigDecimalAverageCollector.create());
    }

    private BigDecimal average(String feature, String scenario) {
        LOGGER.warn("Returning average weighting of {} due to non-match of {} -> {}", new Object[]{this.averageDuration(), feature, scenario});
        return this.averageDuration();
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

