/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.time.ZonedDateTime;
import java.util.List;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.requirements.reports.ScenarioOutcome;

public class ScenarioSummaryOutcome
implements ScenarioOutcome {
    private final String name;
    private final String type;
    private final String id;
    private final TestResult result;
    private final List<String> scenarioReports;
    private final String description;
    private final List<String> steps;
    private final List<String> examples;
    private final int exampleCount;
    private final String parentName;
    private final String parentReport;

    public ScenarioSummaryOutcome(String name, String type, TestResult result, List<String> scenarioReports, String description, List<String> steps, List<String> examples, int exampleCount, String parentName, String parentReport) {
        this.name = name;
        this.type = type;
        this.id = Digest.ofTextValue(name);
        this.result = result;
        this.scenarioReports = scenarioReports;
        this.description = description;
        this.steps = steps;
        this.examples = examples;
        this.exampleCount = exampleCount;
        this.parentName = parentName;
        this.parentReport = parentReport;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimplifiedName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        if ("Background".equalsIgnoreCase(this.type)) {
            return this.backgroundTitle();
        }
        return this.name;
    }

    private String backgroundTitle() {
        if (this.name.isEmpty()) {
            return "Background";
        }
        return "Background: " + this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public TestResult getResult() {
        return this.result;
    }

    @Override
    public String getResultStyle() {
        return this.result.name().toLowerCase();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getSteps() {
        return this.steps;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public boolean hasExamples() {
        return this.exampleCount > 0;
    }

    @Override
    public String getNumberOfExamples() {
        return this.exampleCount == 1 ? "1 example" : this.exampleCount + " examples";
    }

    @Override
    public String getScenarioReport() {
        return "";
    }

    @Override
    public List<String> getScenarioReportBadges() {
        return this.scenarioReports;
    }

    @Override
    public Integer getStepCount() {
        return this.steps.size();
    }

    @Override
    public ZonedDateTime getStartTime() {
        return null;
    }

    @Override
    public Long getDuration() {
        return 0L;
    }

    @Override
    public boolean isManual() {
        return false;
    }

    @Override
    public String getFormattedStartTime() {
        return " ";
    }

    @Override
    public String getFormattedDuration() {
        return " ";
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getParentReport() {
        return this.parentReport;
    }
}

