/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultComparison;

public class DataTableRow {
    private List<? extends Object> values;
    private TestResult result;

    public DataTableRow(List<? extends Object> values) {
        this(values, TestResult.UNDEFINED);
    }

    public DataTableRow(List<? extends Object> values, TestResult result) {
        this.values = new ArrayList<Object>(values);
        this.result = result;
    }

    public List<? extends Object> getValues() {
        return new ArrayList<Object>(this.values);
    }

    public List<String> getStringValues() {
        return this.values.stream().map(value -> value == null ? "" : value.toString()).collect(Collectors.toList());
    }

    public TestResult getResult() {
        return this.result;
    }

    public void setResult(TestResult result) {
        this.result = result;
    }

    public void updateResult(TestResult newResult) {
        if (newResult == TestResult.UNDEFINED) {
            this.setResult(newResult);
        } else {
            this.setResult(TestResultComparison.overallResultFor(this.result, newResult));
        }
    }

    public String toString() {
        return "DataTableRow{values=" + this.values + ", result=" + (Object)((Object)this.result) + '}';
    }
}

