/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.Rule;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.reports.CompoundDuration;
import net.thucydides.core.requirements.reports.ReportBadges;
import net.thucydides.core.requirements.reports.ScenarioOutcome;

public class SingleScenarioOutcome
implements ScenarioOutcome {
    private final String name;
    private final String simplifiedName;
    private final String type;
    private final String id;
    private final TestResult result;
    private final String scenarioReport;
    private final String description;
    private final List<String> steps;
    private final List<String> examples;
    private final int exampleCount;
    private final ZonedDateTime startTime;
    private final Long duration;
    private final Boolean manual;
    private final String parentName;
    private final String parentReport;
    private final Set<TestTag> tags;
    private Rule rule;

    public SingleScenarioOutcome(String name, String simplifiedName, String type, TestResult result, String scenarioReport, ZonedDateTime startTime, Long duration, Boolean manual, String description, List<String> steps, List<String> examples, int exampleCount, String parentName, String parentReport, Set<TestTag> tags, Rule rule) {
        this.name = name;
        this.simplifiedName = simplifiedName;
        this.type = type;
        this.id = Digest.ofTextValue(name);
        this.result = result;
        this.scenarioReport = scenarioReport;
        this.startTime = startTime;
        this.duration = duration;
        this.manual = manual;
        this.description = description;
        this.steps = steps;
        this.examples = examples;
        this.exampleCount = exampleCount;
        this.parentName = parentName;
        this.parentReport = parentReport;
        this.tags = tags;
        this.rule = rule;
    }

    public String toString() {
        return "SingleScenarioOutcome[" + this.name + "]";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimplifiedName() {
        return this.simplifiedName;
    }

    @Override
    public String getTitle() {
        if ("Background".equalsIgnoreCase(this.type)) {
            return this.backgroundTitle();
        }
        return this.name;
    }

    private String backgroundTitle() {
        if (this.name.isEmpty()) {
            return "Background";
        }
        return "Background: " + this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public TestResult getResult() {
        return this.result;
    }

    @Override
    public String getResultStyle() {
        return this.result.name().toLowerCase();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getSteps() {
        return this.steps;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public boolean hasExamples() {
        return this.exampleCount > 0;
    }

    @Override
    public String getNumberOfExamples() {
        return this.exampleCount == 1 ? "1 example" : this.exampleCount + " examples";
    }

    @Override
    public String getScenarioReport() {
        return this.scenarioReport;
    }

    @Override
    public List<String> getScenarioReportBadges() {
        return ReportBadges.forReport(this.scenarioReport);
    }

    @Override
    public Integer getStepCount() {
        return this.steps.size();
    }

    @Override
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public Boolean isManual() {
        return this.manual;
    }

    public Boolean isManualScenario() {
        return this.manual;
    }

    @Override
    public String getFormattedStartTime() {
        return this.startTime != null ? "" + this.startTime.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : "";
    }

    @Override
    public String getFormattedDuration() {
        return this.duration != 0L ? "" + CompoundDuration.of(this.duration) : "";
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getParentReport() {
        return this.parentReport;
    }

    @Override
    public Set<TestTag> getTags() {
        return this.tags;
    }

    @Override
    public Map<String, Collection<TestTag>> getExampleTags() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }
}

