/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.screenplay.exceptions.UnexpectedEnumValueException;
import net.thucydides.core.annotations.Methods;

public class EnumValues {
    private final Class<?> enumType;

    public <T> EnumValues(Class<T> enumType) {
        this.enumType = enumType;
    }

    protected <T> T convertToEnum(Class<T> enumType, String value) {
        try {
            return (T)Methods.of(enumType).called("valueOf").first().invoke(null, value);
        }
        catch (Exception e) {
            throw new UnexpectedEnumValueException("Unknown enum value for " + enumType + " of " + value);
        }
    }

    public static EnumValues forType(Class<?> enumType) {
        return new EnumValues(enumType);
    }

    public <T> T getValueOf(String value) {
        return (T)this.convertToEnum(this.enumType, value);
    }

    public <T> List<T> getValuesOf(List<?> values) {
        ArrayList<Object> convertedValues = new ArrayList<Object>();
        Object lastAttemptedValue = null;
        try {
            for (Object value : values) {
                lastAttemptedValue = value;
                convertedValues.add(Methods.of(this.enumType).called("valueOf").first().invoke(null, value.toString()));
            }
        }
        catch (Exception e) {
            throw new UnexpectedEnumValueException("Unknown enum value for " + this.enumType + ": " + lastAttemptedValue);
        }
        return convertedValues;
    }
}

