/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import java.util.Arrays;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.serenitybdd.screenplay.questions.UIState;

public class JavaScript
extends UIState<String> {
    private final String expression;
    private final Object[] parameters;

    public JavaScript(String expression, Object[] parameters, Actor actor) {
        super(actor);
        this.expression = expression;
        this.parameters = Arrays.copyOf(parameters, parameters.length);
    }

    public static JavaScriptBuilder evaluate(String expression) {
        return new JavaScriptBuilder(expression, new Object[0]);
    }

    @Override
    public String resolve() {
        return BrowseTheWeb.as(this.actor).evaluateJavascript(this.expression, this.parameters).toString();
    }

    public static final class JavaScriptBuilder {
        private final String expression;
        private Object[] parameters = new Object[0];

        public JavaScriptBuilder(String expression, Object ... parameters) {
            this.expression = expression;
            this.parameters = parameters;
        }

        public JavaScriptBuilder withParameters(Object ... parameters) {
            this.parameters = parameters;
            return this;
        }

        public JavaScript viewedBy(Actor actor) {
            return new JavaScript(this.expression, this.parameters, actor);
        }
    }
}

