/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.actors;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.actors.Cast;

public class Stage {
    private Actor actorInTheSpotlight;
    private final Cast cast;

    public Stage(Cast cast) {
        this.cast = cast;
    }

    public Actor shineSpotlightOn(String actorName) {
        Optional<Actor> knownActor = this.cast.getActors().stream().filter(actor -> actor.getName().equalsIgnoreCase(actorName)).findFirst();
        this.actorInTheSpotlight = knownActor.orElseGet(() -> this.cast.actorNamed(actorName, new Ability[0]));
        return this.theActorInTheSpotlight().withNoPronoun();
    }

    public Actor theActorInTheSpotlight() {
        Preconditions.checkNotNull((Object)this.actorInTheSpotlight);
        return this.actorInTheSpotlight;
    }

    public void drawTheCurtain() {
        this.cast.dismissAll();
    }
}

