/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class CopyNonNullProperties {
    private Object source;

    public CopyNonNullProperties(Object source) {
        this.source = source;
    }

    public static CopyNonNullProperties from(Object task) {
        return new CopyNonNullProperties(task);
    }

    public void to(Object target) {
        CopyNonNullProperties.getFields(this.source.getClass()).stream().filter(field -> !field.isSynthetic()).forEach(field -> this.copyFieldValue((Field)field, this.source, target));
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> classToInspect = clazz; classToInspect != null; classToInspect = classToInspect.getSuperclass()) {
            fields.addAll(Arrays.asList(classToInspect.getDeclaredFields()));
        }
        return fields;
    }

    private void copyFieldValue(Field field, Object source, Object target) {
        try {
            field.setAccessible(true);
            Object sourceValue = field.get(source);
            if (sourceValue != null) {
                field.set(target, sourceValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Field targetField(Object target, String name) throws NoSuchFieldException {
        Class<?> performableClass = target.getClass().getSuperclass();
        if (Arrays.stream(performableClass.getDeclaredFields()).anyMatch(field -> field.getName().equals(name))) {
            return performableClass.getDeclaredField(name);
        }
        return performableClass.getField(name);
    }
}

