/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.spring.integration;

import net.serenitybdd.junit.spring.integration.SpringIntegrationRuleBase;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit4.statements.RunAfterTestClassCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestClassCallbacks;

public class SpringIntegrationClassRule
extends SpringIntegrationRuleBase
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(SpringIntegrationClassRule.class);

    public Statement apply(Statement base, Description description) {
        Class testClass = description.getTestClass();
        LOG.debug("Applying class rule to class {}", (Object)testClass.getName());
        return super.apply(base, testClass, null, new SpringIntegrationRuleBase.StatementWrapper(){

            @Override
            public Statement apply(Statement next, TestContextManager testContextManager) {
                return new RunBeforeTestClassCallbacks(next, testContextManager);
            }
        }, new SpringIntegrationRuleBase.StatementWrapper(){

            @Override
            public Statement apply(Statement next, TestContextManager testContextManager) {
                return new RunAfterTestClassCallbacks(next, testContextManager);
            }
        });
    }
}

