/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.di;

import net.serenitybdd.core.di.DependencyInjector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.TestContextManager;

public class SpringDependencyInjector
implements DependencyInjector {
    public void injectDependenciesInto(Object target) {
        if (this.springIsOnClasspath() && (this.annotatedWithSpringContext(target) || this.annotatedWithSpringBootTest(target))) {
            TestContextManager contextManager = this.getTestContextManager(target.getClass());
            try {
                contextManager.prepareTestInstance(target);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate test instance", e);
            }
        }
    }

    public void reset() {
    }

    private boolean annotatedWithSpringContext(Object target) {
        return AnnotationUtils.findAnnotation(target.getClass(), ContextConfiguration.class) != null || AnnotationUtils.findAnnotation(target.getClass(), ContextHierarchy.class) != null;
    }

    private boolean annotatedWithSpringBootTest(Object target) {
        try {
            Class<?> bootTest;
            Class<?> bootTestAnnotation = bootTest = Class.forName("org.springframework.boot.test.context.SpringBootTest");
            return null != AnnotationUtils.findAnnotation(target.getClass(), bootTestAnnotation);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean springIsOnClasspath() {
        try {
            Class.forName("org.springframework.test.context.ContextConfiguration");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected TestContextManager getTestContextManager(Class<?> clazz) {
        return new TestContextManager(clazz);
    }
}

