/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.Namespaces;
import org.exist.collections.CollectionConfiguration;
import org.exist.dom.AttrImpl;
import org.exist.dom.CDATASectionImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.ProgressIndicator;
import org.exist.util.XMLChar;
import org.exist.util.XMLString;
import org.exist.util.pool.NodePool;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class Indexer
extends Observable
implements ContentHandler,
LexicalHandler,
ErrorHandler {
    private static final int CACHE_CHILD_COUNT_MAX = 65536;
    private static final String ATTR_ID_TYPE = "ID";
    private static final String ATTR_IDREF_TYPE = "IDREF";
    private static final String ATTR_IDREFS_TYPE = "IDREFS";
    private static final Logger LOG = Logger.getLogger((Class)Indexer.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "indexer";
    public static final String CONFIGURATION_INDEX_ELEMENT_NAME = "index";
    public static final String SUPPRESS_WHITESPACE_ATTRIBUTE = "suppress-whitespace";
    public static final String PRESERVE_WS_MIXED_CONTENT_ATTRIBUTE = "preserve-whitespace-mixed-content";
    public static final String PROPERTY_INDEXER_CONFIG = "indexer.config";
    public static final String PROPERTY_SUPPRESS_WHITESPACE = "indexer.suppress-whitespace";
    public static final String PROPERTY_PRESERVE_WS_MIXED_CONTENT = "indexer.preserve-whitespace-mixed-content";
    protected DBBroker broker = null;
    protected Txn transaction;
    protected StreamListener indexListener;
    protected XMLString charBuf = new XMLString();
    protected boolean inCDATASection = false;
    protected int currentLine = 0;
    protected NodePath currentPath = new NodePath();
    protected DocumentImpl document = null;
    protected IndexSpec indexSpec = null;
    protected boolean insideDTD = false;
    protected boolean validate = false;
    protected int level = 0;
    protected Locator locator = null;
    protected int normalize = 3;
    protected Map nsMappings = new HashMap();
    protected Element rootNode;
    protected Stack stack = new Stack();
    protected Stack nodeContentStack = new Stack();
    protected StoredNode prevNode = null;
    protected String ignorePrefix = null;
    protected ProgressIndicator progress;
    protected boolean suppressWSmixed = false;
    protected int docSize = 0;
    private int[] childCnt = new int[4096];
    private int elementCnt = 0;
    private int nodeFactoryInstanceCnt = 0;
    private TextImpl text = new TextImpl();
    private Stack usedElements = new Stack();

    public Indexer(DBBroker broker, Txn transaction) throws EXistException {
        this(broker, transaction, false);
    }

    public Indexer(DBBroker broker, Txn transaction, boolean priv) throws EXistException {
        Boolean temp;
        this.broker = broker;
        this.transaction = transaction;
        Configuration config = broker.getConfiguration();
        String suppressWS = (String)config.getProperty(PROPERTY_SUPPRESS_WHITESPACE);
        if (suppressWS != null) {
            if ("leading".equals(suppressWS)) {
                this.normalize = 1;
            } else if ("trailing".equals(suppressWS)) {
                this.normalize = 2;
            } else if ("none".equals(suppressWS)) {
                this.normalize = 0;
            }
        }
        if ((temp = (Boolean)config.getProperty(PROPERTY_PRESERVE_WS_MIXED_CONTENT)) != null) {
            this.suppressWSmixed = temp;
        }
    }

    public void setValidating(boolean validate) {
        this.validate = validate;
        if (!validate) {
            this.broker.getIndexController().setDocument(this.document, 0);
            this.indexListener = this.broker.getIndexController().getStreamListener();
        }
    }

    public void setDocument(DocumentImpl doc, CollectionConfiguration collectionConfig) {
        this.document = doc;
        if (collectionConfig != null) {
            this.indexSpec = collectionConfig.getIndexConfiguration();
        }
        this.level = 0;
        this.currentPath.reset();
        this.stack = new Stack();
        this.docSize = 0;
        this.nsMappings.clear();
        this.indexListener = null;
        this.rootNode = null;
        this.setPrevious(null);
    }

    public void setDocumentObject(DocumentImpl doc) {
        this.document = doc;
    }

    public DocumentImpl getDocument() {
        return this.document;
    }

    public int getDocSize() {
        return this.docSize;
    }

    public void characters(char[] ch, int start, int length) {
        if (length <= 0) {
            return;
        }
        if (this.charBuf != null) {
            this.charBuf.append(ch, start, length);
        } else {
            this.charBuf = new XMLString(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) {
        if (this.insideDTD) {
            return;
        }
        CommentImpl comment = new CommentImpl(ch, start, length);
        comment.setOwnerDocument(this.document);
        if (this.stack.empty()) {
            comment.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            if (!this.validate) {
                this.broker.storeNode(this.transaction, comment, this.currentPath, this.indexSpec);
            }
            this.document.appendChild(comment);
        } else {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                this.text.setData(this.charBuf);
                this.text.setOwnerDocument(this.document);
                last.appendChildInternal(this.prevNode, this.text);
                if (!this.validate) {
                    this.storeText();
                }
                this.setPrevious(this.text);
                this.charBuf.reset();
            }
            last.appendChildInternal(this.prevNode, comment);
            this.setPrevious(comment);
            if (!this.validate) {
                this.broker.storeNode(this.transaction, comment, this.currentPath, this.indexSpec);
            }
        }
    }

    public void endCDATA() {
        if (!this.stack.isEmpty()) {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                CDATASectionImpl cdata = new CDATASectionImpl(this.charBuf);
                cdata.setOwnerDocument(this.document);
                last.appendChildInternal(this.prevNode, cdata);
                if (!this.validate) {
                    this.broker.storeNode(this.transaction, cdata, this.currentPath, this.indexSpec);
                }
                this.setPrevious(cdata);
                if (!this.nodeContentStack.isEmpty()) {
                    for (int i = 0; i < this.nodeContentStack.size(); ++i) {
                        XMLString next = (XMLString)this.nodeContentStack.get(i);
                        next.append(this.charBuf);
                    }
                }
                this.charBuf.reset();
            }
        }
        this.inCDATASection = false;
    }

    public void endDTD() {
        this.insideDTD = false;
    }

    public void endDocument() {
        if (!this.validate) {
            this.progress.finish();
            this.setChanged();
            this.notifyObservers(this.progress);
        }
    }

    public void endElement(String namespace, String name, String qname) {
        ElementImpl last = (ElementImpl)this.stack.peek();
        if (last.getNodeName().equals(qname)) {
            if (this.charBuf != null && this.charBuf.length() > 0) {
                XMLString normalized;
                if (this.charBuf.isWhitespaceOnly() && this.suppressWSmixed || last.preserveSpace()) {
                    normalized = this.charBuf;
                } else {
                    XMLString xMLString = last.getChildCount() == 0 ? this.charBuf.normalize(this.normalize) : (normalized = this.charBuf.isWhitespaceOnly() ? null : this.charBuf);
                }
                if (normalized != null && normalized.length() > 0) {
                    this.text.setData(normalized);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.prevNode, this.text);
                    if (!this.validate) {
                        this.storeText();
                    }
                    this.setPrevious(this.text);
                }
                this.charBuf.reset();
            }
            this.stack.pop();
            XMLString elemContent = null;
            if (!this.validate && GeneralRangeIndexSpec.hasQNameOrValueIndex(last.getIndexType())) {
                elemContent = (XMLString)this.nodeContentStack.pop();
            }
            if (!this.validate) {
                String content = elemContent == null ? null : elemContent.toString();
                this.broker.endElement(last, this.currentPath, content);
                if (this.indexListener != null) {
                    this.indexListener.endElement(this.transaction, last, this.currentPath);
                }
            }
            this.currentPath.removeLastComponent();
            if (this.validate) {
                if (this.childCnt != null) {
                    this.setChildCount(last);
                }
            } else {
                this.document.setOwnerDocument(this.document);
                if (this.childCnt == null && last.getChildCount() > 0 || this.childCnt != null && this.childCnt[last.getPosition()] != last.getChildCount()) {
                    this.broker.updateNode(this.transaction, last, false);
                }
            }
            this.setPrevious(last);
            --this.level;
        }
    }

    private void setChildCount(ElementImpl last) {
        if (last.getPosition() >= this.childCnt.length) {
            if (this.childCnt.length > 65536) {
                this.childCnt = null;
                return;
            }
            int[] n = new int[this.childCnt.length * 2];
            System.arraycopy(this.childCnt, 0, n, 0, this.childCnt.length);
            this.childCnt = n;
        }
        this.childCnt[last.getPosition()] = last.getChildCount();
    }

    public void endEntity(String name) {
    }

    public void endPrefixMapping(String prefix) {
        if (this.ignorePrefix != null && prefix.equals(this.ignorePrefix)) {
            this.ignorePrefix = null;
        } else {
            this.nsMappings.remove(prefix);
        }
    }

    public void error(SAXParseException e) throws SAXException {
        String msg = "error at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        LOG.debug((Object)msg);
        throw new SAXException(msg, e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        String msg = "fatal error at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        LOG.debug((Object)msg);
        throw new SAXException(msg, e);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstructionImpl pi = new ProcessingInstructionImpl(target, data);
        pi.setOwnerDocument(this.document);
        if (this.stack.isEmpty()) {
            pi.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            if (!this.validate) {
                this.broker.storeNode(this.transaction, pi, this.currentPath, this.indexSpec);
            }
            this.document.appendChild(pi);
        } else {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                XMLString normalized = this.charBuf.normalize(this.normalize);
                if (normalized.length() > 0) {
                    this.text.setData(normalized);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.prevNode, this.text);
                    if (!this.validate) {
                        this.storeText();
                    }
                    this.setPrevious(this.text);
                }
                this.charBuf.reset();
            }
            last.appendChildInternal(this.prevNode, pi);
            this.setPrevious(pi);
            if (!this.validate) {
                this.broker.storeNode(this.transaction, pi, this.currentPath, this.indexSpec);
            }
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void setFeature(SAXParserFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException e) {
            LOG.warn((Object)e);
        }
        catch (SAXNotSupportedException snse) {
            LOG.warn((Object)snse);
        }
        catch (ParserConfigurationException pce) {
            LOG.warn((Object)pce);
        }
    }

    public void skippedEntity(String name) {
    }

    public void startCDATA() {
        if (!this.stack.isEmpty()) {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null && this.charBuf.length() > 0) {
                this.text.setData(this.charBuf);
                this.text.setOwnerDocument(this.document);
                last.appendChildInternal(this.prevNode, this.text);
                if (!this.validate) {
                    this.storeText();
                }
                this.setPrevious(this.text);
                this.charBuf.reset();
            }
        }
        this.inCDATASection = true;
    }

    public void startDTD(String name, String publicId, String systemId) {
        DocumentTypeImpl docType = new DocumentTypeImpl(name, publicId, systemId);
        this.document.setDocumentType(docType);
        this.insideDTD = true;
    }

    public void startDocument() {
        if (!this.validate) {
            this.progress = new ProgressIndicator(this.currentLine, 100);
            this.document.setChildCount(0);
            this.elementCnt = 0;
        }
        this.docSize = 0;
    }

    public void startElement(String namespace, String name, String qname, Attributes attributes) throws SAXException {
        ElementImpl node;
        String attrQName;
        String attrNS;
        int attrLength = attributes.getLength();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrNS = attributes.getURI(i);
            attrQName = attributes.getQName(i);
            if (!attrQName.startsWith("xmlns") && !attrNS.equals("http://exist.sourceforge.net/NS/exist")) continue;
            --attrLength;
        }
        int p = qname.indexOf(58);
        String prefix = p != -1 ? qname.substring(0, p) : "";
        QName qn = this.broker.getBrokerPool().getSymbols().getQName((short)1, namespace, name, prefix);
        if (!this.stack.empty()) {
            ElementImpl last = (ElementImpl)this.stack.peek();
            if (this.charBuf != null) {
                if (this.charBuf.isWhitespaceOnly()) {
                    if (this.suppressWSmixed && this.charBuf.length() > 0 && last.getChildCount() > 0) {
                        this.text.setData(this.charBuf);
                        this.text.setOwnerDocument(this.document);
                        last.appendChildInternal(this.prevNode, this.text);
                        if (!this.validate) {
                            this.storeText();
                        }
                        this.setPrevious(this.text);
                    }
                } else if (this.charBuf.length() > 0) {
                    this.text.setData(this.charBuf);
                    this.text.setOwnerDocument(this.document);
                    last.appendChildInternal(this.prevNode, this.text);
                    if (!this.validate) {
                        this.storeText();
                    }
                    this.setPrevious(this.text);
                }
                this.charBuf.reset();
            }
            if (!this.usedElements.isEmpty()) {
                node = (ElementImpl)this.usedElements.pop();
                node.setNodeName(qn);
            } else {
                node = new ElementImpl(qn);
            }
            node.setPreserveSpace(last.preserveSpace());
            last.appendChildInternal(this.prevNode, node);
            this.setPrevious(null);
            node.setOwnerDocument(this.document);
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qn);
            node.setPosition(this.elementCnt++);
            if (!this.validate) {
                if (this.childCnt != null) {
                    node.setChildCount(this.childCnt[node.getPosition()]);
                }
                this.storeElement(node);
            }
        } else {
            node = this.validate ? new ElementImpl(qn) : new ElementImpl(qn);
            this.rootNode = node;
            this.setPrevious(null);
            node.setOwnerDocument(this.document);
            node.setNodeId(this.broker.getBrokerPool().getNodeFactory().createInstance(this.nodeFactoryInstanceCnt++));
            node.setAttributes((short)attrLength);
            if (this.nsMappings != null && this.nsMappings.size() > 0) {
                node.setNamespaceMappings(this.nsMappings);
                this.nsMappings.clear();
            }
            this.stack.push(node);
            this.currentPath.addComponent(qn);
            node.setPosition(this.elementCnt++);
            if (!this.validate) {
                if (this.childCnt != null) {
                    node.setChildCount(this.childCnt[node.getPosition()]);
                }
                this.storeElement(node);
            }
            this.document.appendChild(node);
        }
        ++this.level;
        for (int i = 0; i < attributes.getLength(); ++i) {
            attrNS = attributes.getURI(i);
            String attrLocalName = attributes.getLocalName(i);
            attrQName = attributes.getQName(i);
            if (attrQName.startsWith("xmlns") || attrNS.equals("http://exist.sourceforge.net/NS/exist")) {
                --attrLength;
                continue;
            }
            p = attrQName.indexOf(58);
            String attrPrefix = p != -1 ? attrQName.substring(0, p) : null;
            AttrImpl attr = (AttrImpl)NodePool.getInstance().borrowNode((short)2);
            attr.setNodeName(this.broker.getBrokerPool().getSymbols().getQName((short)2, attrNS, attrLocalName, attrPrefix));
            attr.setValue(attributes.getValue(i));
            attr.setOwnerDocument(this.document);
            if (attributes.getType(i).equals(ATTR_ID_TYPE)) {
                attr.setType(1);
            } else if (attributes.getType(i).equals(ATTR_IDREF_TYPE)) {
                attr.setType(2);
            } else if (attributes.getType(i).equals(ATTR_IDREFS_TYPE)) {
                attr.setType(3);
            } else if (attr.getQName().equalsSimple(Namespaces.XML_ID_QNAME)) {
                attr.setValue(StringValue.trimWhitespace(StringValue.collapseWhitespace(attr.getValue())));
                if (!XMLChar.isValidNCName(attr.getValue())) {
                    throw new SAXException("Value of xml:id attribute is not a valid NCName: " + attr.getValue());
                }
                attr.setType(1);
            } else if (attr.getQName().equalsSimple(Namespaces.XML_SPACE_QNAME)) {
                node.setPreserveSpace("preserve".equals(attr.getValue()));
            }
            node.appendChildInternal(this.prevNode, attr);
            this.setPrevious(attr);
            if (this.validate) continue;
            this.broker.storeNode(this.transaction, attr, this.currentPath, this.indexSpec);
            if (this.indexListener == null) continue;
            this.indexListener.attribute(this.transaction, attr, this.currentPath);
        }
        if (attrLength > 0) {
            node.setAttributes((short)attrLength);
        }
        if (this.locator != null) {
            this.currentLine = this.locator.getLineNumber();
            if (!this.validate) {
                this.progress.setValue(this.currentLine);
                if (this.progress.changed()) {
                    this.setChanged();
                    this.notifyObservers(this.progress);
                }
            }
        }
        ++this.docSize;
    }

    private void storeText() {
        if (!this.nodeContentStack.isEmpty()) {
            for (int i = 0; i < this.nodeContentStack.size(); ++i) {
                XMLString next = (XMLString)this.nodeContentStack.get(i);
                next.append(this.charBuf);
            }
        }
        this.broker.storeNode(this.transaction, this.text, this.currentPath, this.indexSpec);
        if (this.indexListener != null) {
            this.indexListener.characters(this.transaction, this.text, this.currentPath);
        }
    }

    private void storeElement(ElementImpl node) {
        this.broker.storeNode(this.transaction, node, this.currentPath, this.indexSpec);
        if (this.indexListener != null) {
            this.indexListener.startElement(this.transaction, node, this.currentPath);
        }
        node.setChildCount(0);
        if (GeneralRangeIndexSpec.hasQNameOrValueIndex(node.getIndexType())) {
            XMLString contentBuf = new XMLString();
            this.nodeContentStack.push(contentBuf);
        }
    }

    public void startEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.nsMappings.put(prefix, uri);
    }

    public void warning(SAXParseException e) throws SAXException {
        String msg = "warning at (" + e.getLineNumber() + "," + e.getColumnNumber() + ") : " + e.getMessage();
        throw new SAXException(msg, e);
    }

    private void setPrevious(StoredNode previous) {
        if (this.prevNode != null) {
            switch (this.prevNode.getNodeType()) {
                case 2: {
                    this.prevNode.release();
                    break;
                }
                case 1: {
                    if (this.prevNode == this.rootNode) break;
                    this.prevNode.clear();
                    this.usedElements.push(this.prevNode);
                    break;
                }
                case 3: {
                    this.prevNode.clear();
                }
            }
        }
        this.prevNode = previous;
    }
}

