/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import javax.swing.JFrame;
import org.exist.backup.BackupDialog;
import org.exist.backup.BackupWriter;
import org.exist.backup.FileSystemWriter;
import org.exist.backup.ZipWriter;
import org.exist.security.Permission;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class Backup {
    private String target;
    private XmldbURI rootCollection;
    private String user;
    private String pass;
    private static final int currVersion = 1;
    public Properties defaultOutputProperties = new Properties();
    public Properties contentsOutputProps;

    public Backup(String user, String pass, String target, XmldbURI rootCollection) {
        this.defaultOutputProperties.setProperty("indent", "no");
        this.defaultOutputProperties.setProperty("encoding", "UTF-8");
        this.defaultOutputProperties.setProperty("omit-xml-declaration", "no");
        this.defaultOutputProperties.setProperty("expand-xincludes", "no");
        this.defaultOutputProperties.setProperty("process-xsl-pi", "no");
        this.contentsOutputProps = new Properties();
        this.contentsOutputProps.setProperty("indent", "yes");
        this.user = user;
        this.pass = pass;
        this.target = target;
        this.rootCollection = rootCollection;
    }

    public Backup(String user, String pass, String target) {
        this(user, pass, target, XmldbURI.create("xmldb:exist:///db"));
    }

    public Backup(String user, String pass, String target, XmldbURI rootCollection, Properties property) {
        this(user, pass, target, rootCollection);
        this.defaultOutputProperties.setProperty("indent", property.getProperty("indent", "no"));
    }

    public static String encode(String enco) {
        StringBuffer out = new StringBuffer();
        for (int y = 0; y < enco.length(); ++y) {
            char t = enco.charAt(y);
            if (t == '\"') {
                out.append("&22;");
                continue;
            }
            if (t == '&') {
                out.append("&26;");
                continue;
            }
            if (t == '*') {
                out.append("&2A;");
                continue;
            }
            if (t == ':') {
                out.append("&3A;");
                continue;
            }
            if (t == '<') {
                out.append("&3C;");
                continue;
            }
            if (t == '>') {
                out.append("&3E;");
                continue;
            }
            if (t == '?') {
                out.append("&3F;");
                continue;
            }
            if (t == '\\') {
                out.append("&5C;");
                continue;
            }
            if (t == '|') {
                out.append("&7C;");
                continue;
            }
            out.append(t);
        }
        return out.toString();
    }

    public static String decode(String enco) {
        StringBuffer out = new StringBuffer();
        String temp = "";
        for (int y = 0; y < enco.length(); ++y) {
            char t = enco.charAt(y);
            if (t != '&') {
                out.append(t);
                continue;
            }
            temp = enco.substring(y, y + 4);
            if (temp.equals("&22;")) {
                out.append('\"');
            } else if (temp.equals("&26;")) {
                out.append('&');
            } else if (temp.equals("&2A;")) {
                out.append('*');
            } else if (temp.equals("&3A;")) {
                out.append(':');
            } else if (temp.equals("&3C;")) {
                out.append('<');
            } else if (temp.equals("&3E;")) {
                out.append(">");
            } else if (temp.equals("&3F;")) {
                out.append('?');
            } else if (temp.equals("&5C;")) {
                out.append('\\');
            } else if (temp.equals("&7C;")) {
                out.append('|');
            }
            y += 3;
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(boolean guiMode, JFrame parent) throws XMLDBException, IOException, SAXException {
        Collection current = DatabaseManager.getCollection((String)this.rootCollection.toString(), (String)this.user, (String)this.pass);
        if (guiMode) {
            BackupDialog dialog = new BackupDialog((Frame)parent, false);
            dialog.setSize(new Dimension(350, 150));
            dialog.setVisible(true);
            BackupThread thread = new BackupThread(current, dialog);
            thread.start();
            if (parent == null) {
                while (thread.isAlive()) {
                    Backup backup = this;
                    synchronized (backup) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
            }
        } else {
            this.backup(current, null);
        }
    }

    private void backup(Collection current, BackupDialog dialog) throws XMLDBException, IOException, SAXException {
        String cname = current.getName();
        if (cname.charAt(0) != '/') {
            cname = "/" + cname;
        }
        String path = this.target + Backup.encode(URIUtils.urlDecodeUtf8(cname));
        BackupWriter output = this.target.endsWith(".zip") ? new ZipWriter(this.target, Backup.encode(URIUtils.urlDecodeUtf8(cname))) : new FileSystemWriter(path);
        this.backup(current, output, dialog);
        output.close();
    }

    private void backup(Collection current, BackupWriter output, BackupDialog dialog) throws XMLDBException, IOException, SAXException {
        if (current == null) {
            return;
        }
        current.setProperty("encoding", this.defaultOutputProperties.getProperty("encoding"));
        current.setProperty("indent", this.defaultOutputProperties.getProperty("indent"));
        current.setProperty("expand-xincludes", this.defaultOutputProperties.getProperty("expand-xincludes"));
        current.setProperty("process-xsl-pi", this.defaultOutputProperties.getProperty("process-xsl-pi"));
        Object[] resources = current.listResources();
        Arrays.sort(resources);
        UserManagementService mgtService = (UserManagementService)current.getService("UserManagementService", "1.0");
        Permission[] perms = mgtService.listResourcePermissions();
        Permission currentPerms = mgtService.getPermissions(current);
        if (dialog != null) {
            dialog.setCollection(current.getName());
            dialog.setResourceCount(resources.length);
        }
        Writer contents = output.newContents();
        SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        serializer.setOutput(contents, this.contentsOutputProps);
        serializer.startDocument();
        serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
        CollectionImpl cur = (CollectionImpl)current;
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", current.getName());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", currentPerms.getOwner());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", currentPerms.getOwnerGroup());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(currentPerms.getPermissions()));
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", "" + new DateTimeValue(cur.getCreationTime()));
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
        serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
        for (int i = 0; i < resources.length; ++i) {
            try {
                if (((String)resources[i]).equals("__contents__.xml")) continue;
                Resource resource = current.getResource((String)resources[i]);
                if (dialog != null) {
                    dialog.setResource((String)resources[i]);
                    dialog.setProgress(i);
                }
                OutputStream os = output.newEntry(Backup.encode(URIUtils.urlDecodeUtf8((String)resources[i])));
                if (resource.getResourceType().equals("BinaryResource")) {
                    byte[] bdata = (byte[])resource.getContent();
                    os.write(bdata);
                } else {
                    try {
                        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                        SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(class$org$exist$util$serializer$SAXSerializer == null ? Backup.class$("org.exist.util.serializer.SAXSerializer") : class$org$exist$util$serializer$SAXSerializer);
                        contentSerializer.setOutput(writer, this.defaultOutputProperties);
                        ((EXistResource)resource).setLexicalHandler(contentSerializer);
                        ((XMLResource)resource).getContentAsSAX((ContentHandler)contentSerializer);
                        SerializerPool.getInstance().returnObject(contentSerializer);
                        writer.flush();
                    }
                    catch (Exception e) {
                        System.err.println("An exception occurred while writing the resource: " + e.getMessage());
                        e.printStackTrace();
                        continue;
                    }
                }
                output.closeEntry();
                EXistResource ris = (EXistResource)resource;
                attr.clear();
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", resource.getResourceType());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", (String)resources[i]);
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", perms[i].getOwner());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", perms[i].getOwnerGroup());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", Integer.toOctalString(perms[i].getPermissions()));
                Date date = ris.getCreationTime();
                if (date != null) {
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", "" + new DateTimeValue(date));
                }
                if ((date = ris.getLastModificationTime()) != null) {
                    attr.addAttribute("http://exist.sourceforge.net/NS/exist", "modified", "modified", "CDATA", "" + new DateTimeValue(date));
                }
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8((String)resources[i])));
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mimetype", "mimetype", "CDATA", Backup.encode(((EXistResource)resource).getMimeType()));
                if (!resource.getResourceType().equals("BinaryResource") && ris.getDocType() != null) {
                    if (ris.getDocType().getName() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "namedoctype", "namedoctype", "CDATA", ris.getDocType().getName());
                    }
                    if (ris.getDocType().getPublicId() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "publicid", "publicid", "CDATA", ris.getDocType().getPublicId());
                    }
                    if (ris.getDocType().getSystemId() != null) {
                        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "systemid", "systemid", "CDATA", ris.getDocType().getSystemId());
                    }
                }
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "resource", attr);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "resource");
                continue;
            }
            catch (XMLDBException e) {
                System.err.println("Failed to backup resource " + (String)resources[i] + " from collection " + current.getName());
            }
        }
        String[] collections = current.listChildCollections();
        for (int i = 0; i < collections.length; ++i) {
            if (current.getName().equals("/db/system") && collections[i].equals("temp")) continue;
            attr.clear();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", collections[i]);
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(collections[i])));
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection", attr);
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection");
        }
        serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
        serializer.endPrefixMapping("");
        serializer.endDocument();
        output.closeContents();
        SerializerPool.getInstance().returnObject(serializer);
        for (int i = 0; i < collections.length; ++i) {
            Collection child = current.getChildCollection(collections[i]);
            if (child.getName().equals("/db/system/temp")) continue;
            output.newCollection(Backup.encode(URIUtils.urlDecodeUtf8(collections[i])));
            this.backup(child, output, dialog);
            output.closeCollection();
        }
    }

    public static void main(String[] args) {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            Backup backup = new Backup("admin", null, "backup", URIUtils.encodeXmldbUriFor(args[0]));
            backup.backup(false, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class BackupThread
    extends Thread {
        Collection collection_;
        BackupDialog dialog_;

        public BackupThread(Collection collection, BackupDialog dialog) {
            this.collection_ = collection;
            this.dialog_ = dialog;
        }

        public void run() {
            try {
                Backup.this.backup(this.collection_, this.dialog_);
                this.dialog_.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

