/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.util.EXistInputSource;
import org.exist.util.FileInputSource;

public class FileSystemBackupDescriptor
extends AbstractBackupDescriptor {
    protected File descriptor;

    public FileSystemBackupDescriptor(File theDesc) throws FileNotFoundException {
        if (!(theDesc.getName().equals("__contents__.xml") && theDesc.isFile() && theDesc.canRead())) {
            throw new FileNotFoundException(theDesc.getAbsolutePath() + " is not a valid collection descriptor");
        }
        this.descriptor = theDesc;
    }

    public BackupDescriptor getChildBackupDescriptor(String describedItem) {
        File child = new File(new File(this.descriptor.getParentFile(), describedItem), "__contents__.xml");
        FileSystemBackupDescriptor bd = null;
        try {
            bd = new FileSystemBackupDescriptor(child);
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        return bd;
    }

    public BackupDescriptor getBackupDescriptor(String describedItem) {
        String topDir = this.descriptor.getParentFile().getParentFile().getAbsolutePath();
        String subDir = topDir + describedItem;
        String desc = subDir + '/' + "__contents__.xml";
        FileSystemBackupDescriptor bd = null;
        try {
            bd = new FileSystemBackupDescriptor(new File(desc));
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        return bd;
    }

    public EXistInputSource getInputSource() {
        return new FileInputSource(this.descriptor);
    }

    public EXistInputSource getInputSource(String describedItem) {
        File child = new File(this.descriptor.getParentFile(), describedItem);
        FileInputSource is = null;
        if (child.isFile() && child.canRead()) {
            is = new FileInputSource(child);
        }
        return is;
    }

    public String getSymbolicPath() {
        return this.descriptor.getAbsolutePath();
    }

    public String getSymbolicPath(String describedItem, boolean isChildDescriptor) {
        File resbase = new File(this.descriptor.getParentFile(), describedItem);
        if (isChildDescriptor) {
            resbase = new File(resbase, "__contents__.xml");
        }
        return resbase.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties() throws IOException {
        File parentDir;
        File dir = this.descriptor.getParentFile();
        if (dir != null && (parentDir = dir.getParentFile()) != null) {
            File propFile = new File(parentDir, "backup.properties");
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));
                Properties properties = new Properties();
                try {
                    properties.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                return properties;
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        return null;
    }

    public File getParentDir() {
        return this.descriptor.getParentFile().getParentFile().getParentFile();
    }

    public String getName() {
        return this.descriptor.getParentFile().getParentFile().getName();
    }
}

