/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.util.EXistInputSource;
import org.exist.util.ZipEntryInputSource;

public class ZipArchiveBackupDescriptor
extends AbstractBackupDescriptor {
    protected ZipFile archive;
    protected ZipEntry descriptor;
    protected String base;

    public ZipArchiveBackupDescriptor(File fileArchive) throws ZipException, IOException, FileNotFoundException {
        this.archive = new ZipFile(fileArchive);
        this.base = "db/";
        this.descriptor = this.archive.getEntry(this.base + "__contents__.xml");
        if (this.descriptor == null || this.descriptor.isDirectory()) {
            throw new FileNotFoundException("Archive " + fileArchive.getAbsolutePath() + " is not a valid eXist backup archive");
        }
    }

    private ZipArchiveBackupDescriptor(ZipFile archive, String base) throws FileNotFoundException {
        this.archive = archive;
        this.base = base;
        this.descriptor = archive.getEntry(base + "__contents__.xml");
        if (this.descriptor == null || this.descriptor.isDirectory()) {
            throw new FileNotFoundException(archive.getName() + " is a bit corrupted (" + base + " descriptor not found): not a valid eXist backup archive");
        }
    }

    public BackupDescriptor getChildBackupDescriptor(String describedItem) {
        ZipArchiveBackupDescriptor bd = null;
        try {
            bd = new ZipArchiveBackupDescriptor(this.archive, this.base + describedItem + "/");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    public BackupDescriptor getBackupDescriptor(String describedItem) {
        if (describedItem.length() > 0 && describedItem.charAt(0) == '/') {
            describedItem = describedItem.substring(1);
        }
        if (!describedItem.endsWith("/")) {
            describedItem = describedItem + '/';
        }
        ZipArchiveBackupDescriptor bd = null;
        try {
            bd = new ZipArchiveBackupDescriptor(this.archive, describedItem);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    public EXistInputSource getInputSource() {
        return new ZipEntryInputSource(this.archive, this.descriptor);
    }

    public EXistInputSource getInputSource(String describedItem) {
        ZipEntry ze = this.archive.getEntry(this.base + describedItem);
        ZipEntryInputSource retval = null;
        if (ze != null && !ze.isDirectory()) {
            retval = new ZipEntryInputSource(this.archive, ze);
        }
        return retval;
    }

    public String getSymbolicPath() {
        return this.archive.getName() + "#" + this.descriptor.getName();
    }

    public String getSymbolicPath(String describedItem, boolean isChildDescriptor) {
        String retval = this.archive.getName() + "#" + this.base + describedItem;
        if (isChildDescriptor) {
            retval = retval + "/__contents__.xml";
        }
        return retval;
    }

    public Properties getProperties() throws IOException {
        Properties properties = null;
        ZipEntry ze = this.archive.getEntry("backup.properties");
        if (ze != null) {
            properties = new Properties();
            properties.load(this.archive.getInputStream(ze));
        }
        return properties;
    }

    public File getParentDir() {
        return new File(this.archive.getName()).getParentFile();
    }

    public String getName() {
        return new File(this.archive.getName()).getName();
    }
}

