/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exist.backup.BackupWriter;

public class ZipWriter
implements BackupWriter {
    private String currentPath;
    private ZipOutputStream out;
    private StringWriter contents;
    private boolean dataWritten = false;

    public ZipWriter(String zipFile, String collection) throws IOException {
        this(new File(zipFile), collection);
    }

    public ZipWriter(File zipFile, String collection) throws IOException {
        this.out = new ZipOutputStream(new FileOutputStream(zipFile));
        this.currentPath = collection;
    }

    public Writer newContents() throws IOException {
        this.contents = new StringWriter();
        return this.contents;
    }

    public void closeContents() throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + "/__contents__.xml");
        this.out.putNextEntry(entry);
        this.out.write(this.contents.toString().getBytes("UTF-8"));
        this.out.closeEntry();
        this.dataWritten = true;
    }

    public OutputStream newEntry(String name) throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + '/' + name);
        this.out.putNextEntry(entry);
        this.dataWritten = true;
        return this.out;
    }

    public void closeEntry() throws IOException {
        this.out.closeEntry();
    }

    public void newCollection(String name) {
        this.currentPath = name.startsWith("/") ? name : this.currentPath + '/' + name;
    }

    public void closeCollection() {
        int p = this.currentPath.lastIndexOf(47);
        if (p > 0) {
            this.currentPath = this.currentPath.substring(0, p);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void setProperties(Properties properties) throws IOException {
        if (this.dataWritten) {
            throw new IOException("Backup properties need to be set before any backup data is written");
        }
        ZipEntry entry = new ZipEntry("backup.properties");
        this.out.putNextEntry(entry);
        properties.store(this.out, "Backup properties");
        this.out.closeEntry();
    }

    private String mkRelative(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }
}

