/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.exist.client.InteractiveClient;
import org.exist.security.User;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.XMLDBException;

class UserDialog
extends JFrame {
    UserManagementService service;
    JTextField username;
    JPasswordField password1;
    JPasswordField password2;
    JTextField homedir;
    JList groups;
    JList allGroups;
    DefaultListModel groupsModel;
    DefaultListModel allGroupsModel;
    JTable users;
    UserTableModel userModel;
    InteractiveClient client;

    public UserDialog(UserManagementService service, String title, InteractiveClient client) throws XMLDBException {
        super(title);
        this.service = service;
        this.client = client;
        this.setupComponents();
    }

    private void setupComponents() throws XMLDBException {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        this.userModel = new UserTableModel(this.service);
        this.users = new JTable(this.userModel);
        this.users.setSelectionMode(0);
        this.users.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    UserDialog.this.tableSelectAction(e);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.users);
        scroll.setPreferredSize(new Dimension(250, 150));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.5;
        grid.setConstraints(scroll, c);
        this.getContentPane().add(scroll);
        JComponent toolbar = this.getToolbar();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(toolbar, c);
        this.getContentPane().add(toolbar);
        JLabel label = new JLabel("Username");
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.username = new JTextField(15);
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 13;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.username, c);
        this.getContentPane().add(this.username);
        label = new JLabel("Password");
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.password1 = new JPasswordField(15);
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 13;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.password1, c);
        this.getContentPane().add(this.password1);
        label = new JLabel("Password (repeat)");
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.password2 = new JPasswordField(15);
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 13;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.password2, c);
        this.getContentPane().add(this.password2);
        label = new JLabel("Home-Collection");
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        this.homedir = new JTextField(20);
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 13;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        grid.setConstraints(this.homedir, c);
        this.getContentPane().add(this.homedir);
        JPanel groupsPanel = this.getGroupsPanel();
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        grid.setConstraints(groupsPanel, c);
        this.getContentPane().add(groupsPanel);
        this.pack();
    }

    private JComponent getToolbar() {
        Box box = Box.createHorizontalBox();
        JButton button = new JButton("Create User");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionCreateUser();
            }
        });
        box.add(button);
        button = new JButton("Modify User");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionModify();
            }
        });
        box.add(button);
        button = new JButton("Remove");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionRemove();
            }
        });
        box.add(button);
        button = new JButton("Reset");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionClear();
            }
        });
        box.add(button);
        return box;
    }

    private JPanel getGroupsPanel() throws XMLDBException {
        JPanel panel = new JPanel(false);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Groups"));
        this.groupsModel = new DefaultListModel();
        this.groups = new JList(this.groupsModel);
        JScrollPane scroll = new JScrollPane(this.groups);
        scroll.setPreferredSize(new Dimension(150, 150));
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Assigned"));
        panel.add(scroll);
        Box box = Box.createVerticalBox();
        URL url = this.getClass().getResource("icons/Back16.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionAssignGroup();
            }
        });
        button.setToolTipText("Assign group");
        box.add(button);
        url = this.getClass().getResource("icons/Forward16.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Remove group");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionRemoveGroup();
            }
        });
        box.add(button);
        url = this.getClass().getResource("icons/New16.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText("Create new group");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserDialog.this.actionNewGroup();
            }
        });
        box.add(button);
        panel.add(box);
        this.allGroupsModel = new DefaultListModel();
        this.updateGroups();
        this.allGroups = new JList(this.allGroupsModel);
        scroll = new JScrollPane(this.allGroups);
        scroll.setPreferredSize(new Dimension(150, 150));
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "All"));
        panel.add(scroll);
        return panel;
    }

    private void updateGroups() throws XMLDBException {
        String[] gl = this.service.getGroups();
        for (int i = 0; i < gl.length; ++i) {
            this.allGroupsModel.addElement(gl[i]);
        }
    }

    private void actionAssignGroup() {
        Object[] selected = this.allGroups.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            if (this.groupsModel.contains(selected[i])) continue;
            this.groupsModel.addElement(selected[i]);
        }
    }

    private void actionRemoveGroup() {
        int[] selected = this.groups.getSelectedIndices();
        for (int i = 0; i < selected.length; ++i) {
            this.groupsModel.remove(selected[i]);
        }
    }

    private void actionNewGroup() {
        String newGroup = JOptionPane.showInputDialog(this, "Please enter a name for the new group", "New Group", 3);
        this.groupsModel.addElement(newGroup);
        this.allGroupsModel.addElement(newGroup);
    }

    private void actionCreateUser() {
        String pass2;
        String name = this.username.getText();
        if (name.length() == 0) {
            return;
        }
        User user = new User(name);
        String pass1 = new String(this.password1.getPassword());
        if (!pass1.equals(pass2 = new String(this.password2.getPassword()))) {
            JOptionPane.showMessageDialog(this, "Different passwords. Please check.");
            return;
        }
        user.setPassword(pass1);
        try {
            user.setHome(XmldbURI.xmldbUriFor(this.homedir.getText()));
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        if (this.groupsModel.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please assign a group to the new user");
            return;
        }
        for (int i = 0; i < this.groupsModel.size(); ++i) {
            user.addGroup((String)this.groupsModel.elementAt(i));
        }
        try {
            this.service.addUser(user);
            this.client.reloadCollection();
            this.userModel.reload();
        }
        catch (XMLDBException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void actionModify() {
        String name = this.username.getText();
        if (name.length() == 0) {
            return;
        }
        User user = new User(name);
        String pass1 = new String(this.password1.getPassword());
        String pass2 = new String(this.password2.getPassword());
        if (pass1.length() == 0 && JOptionPane.showConfirmDialog(this, "No password set. Are you sure?", "Password missing", 0) == 1) {
            return;
        }
        if (!pass1.equals(pass2)) {
            JOptionPane.showMessageDialog(this, "Different passwords. Please check.");
            return;
        }
        user.setPassword(pass1);
        try {
            user.setHome(XmldbURI.xmldbUriFor(this.homedir.getText()));
        }
        catch (URISyntaxException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            return;
        }
        for (int i = 0; i < this.groupsModel.size(); ++i) {
            user.addGroup((String)this.groupsModel.elementAt(i));
        }
        try {
            this.service.updateUser(user);
            String myUser = this.client.properties.getProperty("user", "admin");
            if (name.equals(myUser)) {
                this.client.properties.setProperty("password", pass1);
                this.client.reloadCollection();
            }
            this.userModel.reload();
        }
        catch (XMLDBException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void actionRemove() {
        int[] selected = this.users.getSelectedRows();
        if (selected.length == 0) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the selected users?", "Remove users", 0) == 1) {
            return;
        }
        for (int i = 0; i < selected.length; ++i) {
            User user = this.userModel.users[selected[i]];
            try {
                this.service.removeUser(user);
                this.client.reloadCollection();
                this.userModel.reload();
                continue;
            }
            catch (XMLDBException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        }
    }

    private void actionClear() {
        this.groupsModel.clear();
        this.username.setText("");
        this.password1.setText("");
        this.password2.setText("");
        this.homedir.setText("");
    }

    private void tableSelectAction(MouseEvent ev) {
        int row = this.users.rowAtPoint(ev.getPoint());
        User user = this.userModel.users[row];
        this.username.setText(user.getName());
        this.groupsModel.clear();
        this.password1.setText("");
        this.password2.setText("");
        if (user.getHome() != null) {
            this.homedir.setText(user.getHome().toString());
        } else {
            this.homedir.setText("");
        }
        String[] groups = user.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            this.groupsModel.addElement(groups[i]);
        }
    }

    class UserTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"UID", "User", "Groups", "Home"};
        private User[] users = null;

        public UserTableModel(UserManagementService service) throws XMLDBException {
            this.reload();
        }

        public void reload() throws XMLDBException {
            this.users = UserDialog.this.service.getUsers();
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return this.users == null ? 0 : this.users.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return new Integer(this.users[rowIndex].getUID());
                }
                case 1: {
                    return this.users[rowIndex].getName();
                }
                case 2: {
                    StringBuffer buf = new StringBuffer();
                    String[] groups = this.users[rowIndex].getGroups();
                    for (int i = 0; i < groups.length; ++i) {
                        buf.append(groups[i]);
                        if (i + 1 >= groups.length) continue;
                        buf.append(';');
                    }
                    return buf.toString();
                }
                case 3: {
                    return this.users[rowIndex].getHome();
                }
            }
            return null;
        }
    }
}

