/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.client.xacml.AbstractPolicyNode;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.PolicyElementNode;
import org.exist.client.xacml.PolicyNode;
import org.exist.client.xacml.XACMLTreeNode;

public class PolicySetNode
extends AbstractPolicyNode {
    private List children;
    private List originalChildren;

    public PolicySetNode(NodeContainer parent, PolicySet policySet) {
        this(parent, null, policySet);
    }

    public PolicySetNode(NodeContainer parent, String documentName, PolicySet policySet) {
        super(parent, documentName, (AbstractPolicy)policySet);
        List toCopy = policySet.getChildren();
        this.children = new ArrayList(toCopy.size());
        Iterator it = toCopy.iterator();
        while (it.hasNext()) {
            this.add((PolicyTreeElement)((AbstractPolicy)it.next()));
        }
        this.originalChildren = new ArrayList(this.children);
    }

    public PolicyTreeElement create() {
        return this.createPolicySet();
    }

    public PolicyTreeElement create(URI id) {
        return this.createPolicySet(id);
    }

    public PolicySet createPolicySet() {
        return this.createPolicySet(null);
    }

    public PolicySet createPolicySet(URI id) {
        CombiningAlgorithm alg = this.getCombiningAlgorithm();
        if (!(alg instanceof PolicyCombiningAlgorithm)) {
            throw new IllegalStateException("Combining algorithm must be a policy combining algorithm");
        }
        PolicyCombiningAlgorithm algorithm = (PolicyCombiningAlgorithm)alg;
        Target target = this.getTarget().getTarget();
        ArrayList<PolicyTreeElement> copy = new ArrayList<PolicyTreeElement>(this.children.size());
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            copy.add(((PolicyElementNode)it.next()).create());
        }
        URI useId = id == null ? this.getId() : id;
        return new PolicySet(useId, algorithm, this.getDescription(), target, copy);
    }

    public void add(PolicyTreeElement element) {
        this.add(-1, element);
    }

    public void add(int index, PolicyTreeElement element) {
        if (element == null) {
            return;
        }
        if (element instanceof Policy) {
            this.add(index, new PolicyNode((NodeContainer)this, (Policy)element));
        } else if (element instanceof PolicySet) {
            this.add(index, new PolicySetNode((NodeContainer)this, (PolicySet)element));
        } else {
            throw new IllegalArgumentException("Only Policies and PolicySets can be top level elements.");
        }
    }

    public void add(PolicyElementNode node) {
        this.add(-1, node);
    }

    public void add(int index, PolicyElementNode node) {
        if (node == null) {
            return;
        }
        if (node.getParent() != this) {
            throw new IllegalArgumentException("Cannot add a PolicyElementNode to a parent other than its declared parent.");
        }
        if (node instanceof AbstractPolicyNode) {
            if (index < 0) {
                index = this.children.size() + 1;
            }
            if (index == 0) {
                throw new IllegalArgumentException("Cannot insert AbstractPolicy before Target");
            }
        } else {
            throw new IllegalArgumentException("Only PolicyNodes and PolicySetNodes can be top level elements.");
        }
        this.children.add(index - 1, node);
        this.setModified(true);
        this.nodeAdded(node, index);
    }

    public void remove(PolicyElementNode node) {
        if (node == null) {
            return;
        }
        int index = this.children.indexOf(node);
        if (index < 0) {
            return;
        }
        this.children.remove(index);
        this.setModified(true);
        this.nodeRemoved(node, index + 1);
    }

    public boolean containsId(String id) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            if (!((AbstractPolicyNode)it.next()).getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    public int getChildCount() {
        return this.children.size() + 1;
    }

    public XACMLTreeNode getChild(int index) {
        return index == 0 ? this.getTarget() : (XACMLTreeNode)this.children.get(index - 1);
    }

    public int indexOfChild(Object child) {
        if (child == this.getTarget()) {
            return 0;
        }
        int ret = this.children.indexOf(child);
        return ret >= 0 ? ret + 1 : -1;
    }

    public boolean isModified(boolean deep) {
        if (super.isModified(deep)) {
            return true;
        }
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                if (!((PolicyElementNode)it.next()).isModified(true)) continue;
                return true;
            }
        }
        return false;
    }

    public void revert(boolean deep) {
        this.children = this.originalChildren;
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((PolicyElementNode)it.next()).revert(true);
            }
        }
        super.revert(deep);
    }

    public void commit(boolean deep) {
        this.originalChildren = this.children;
        if (deep) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                ((PolicyElementNode)it.next()).commit(true);
            }
        }
        super.commit(deep);
    }
}

