/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster;

import java.io.Serializable;
import org.exist.cluster.ClusterComunication;
import org.exist.cluster.ClusterException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public abstract class ClusterEvent
implements Serializable {
    public static final int NO_EVENT = -1;
    private static final long serialVersionUID = 0L;
    protected String collectionName;
    protected String documentName;
    private int id = -1;
    private int counter = 1;

    public ClusterEvent() {
    }

    protected ClusterEvent(String documentName, String collectionName) {
        this.documentName = documentName;
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public boolean equals(Object o) {
        if (o instanceof ClusterEvent) {
            return this.hashCode() == ((ClusterEvent)o).hashCode();
        }
        return false;
    }

    public abstract void execute() throws ClusterException;

    public XMLResource getResource() throws XMLDBException {
        Collection collection = this.getCollection();
        return (XMLResource)collection.createResource(this.documentName, "XMLResource");
    }

    public Collection getCollection(String cName) throws XMLDBException {
        return DatabaseManager.getCollection((String)("xmldb:exist://" + cName), (String)ClusterComunication.getDbaUser(), (String)ClusterComunication.getDbaPwd());
    }

    public Collection getCollection() throws XMLDBException {
        return this.getCollection(this.collectionName);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }
}

