/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster.cocoon;

import java.io.IOException;
import org.apache.cocoon.generation.AbstractGenerator;
import org.exist.cluster.ClusterComunication;
import org.exist.cluster.ClusterException;
import org.exist.storage.report.XMLStatistics;
import org.exist.util.Configuration;
import org.jgroups.Address;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ClusterInfoGenerator
extends AbstractGenerator {
    public static final String NAMESPACE = "http://exist.sourceforge.net/generators/cluster";
    public static final String PREFIX = "cluster";
    XMLStatistics stats;

    public void generate() throws IOException, SAXException {
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping(PREFIX, NAMESPACE);
        this.contentHandler.startPrefixMapping("ci", "http://apache.org/cocoon/include/1.0");
        this.contentHandler.startElement(NAMESPACE, "page", "cluster:page", new AttributesImpl());
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "src", "src", "CDATA", "sidebar.xml");
        this.contentHandler.startElement("http://apache.org/cocoon/include/1.0", "include", "ci:include", attr);
        this.contentHandler.endElement("http://apache.org/cocoon/include/1.0", "include", "ci:include");
        this.genInfos();
        this.contentHandler.endElement(NAMESPACE, "page", "cluster:page");
        this.contentHandler.endPrefixMapping(PREFIX);
        this.contentHandler.endPrefixMapping("ci");
        this.contentHandler.endDocument();
    }

    private void genInfos() throws SAXException {
        ClusterComunication cluster = ClusterComunication.getInstance();
        if (cluster == null) {
            return;
        }
        try {
            boolean coordinator = cluster.isCoordinator();
            Address localaddress = cluster.getAddress();
            int[][] headers = cluster.getHeaders();
            AttributesImpl atts = new AttributesImpl();
            AttributesImpl inner = new AttributesImpl();
            atts.addAttribute("", "ismaster", "ismaster", "CDATA", "" + coordinator);
            atts.addAttribute("", "name", "name", "CDATA", "" + localaddress);
            this.contentHandler.startElement(NAMESPACE, "node", "cluster:node", atts);
            atts = new AttributesImpl();
            atts.addAttribute("", "type", "type", "CDATA", "headers");
            this.contentHandler.startElement(NAMESPACE, "info", "cluster:info", atts);
            inner.addAttribute("", "name", "name", "CDATA", "lastId");
            inner.addAttribute("", "value", "value", "CDATA", "" + headers[0][0]);
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "maxId");
            inner.addAttribute("", "value", "value", "CDATA", "" + headers[0][1]);
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "counter");
            inner.addAttribute("", "value", "value", "CDATA", "" + headers[0][2]);
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            this.contentHandler.endElement(NAMESPACE, "info", "cluster:info");
            if (!coordinator) {
                atts = new AttributesImpl();
                atts.addAttribute("", "type", "type", "CDATA", "master-headers");
                this.contentHandler.startElement(NAMESPACE, "info", "cluster:info", atts);
                inner = new AttributesImpl();
                inner.addAttribute("", "name", "name", "CDATA", "lastId");
                inner.addAttribute("", "value", "value", "CDATA", "" + headers[1][0]);
                this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
                this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
                inner = new AttributesImpl();
                inner.addAttribute("", "name", "name", "CDATA", "maxId");
                inner.addAttribute("", "value", "value", "CDATA", "" + headers[1][1]);
                this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
                this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
                inner = new AttributesImpl();
                inner.addAttribute("", "name", "name", "CDATA", "counter");
                inner.addAttribute("", "value", "value", "CDATA", "" + headers[1][2]);
                this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
                this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
                this.contentHandler.endElement(NAMESPACE, "info", "cluster:info");
            }
            Configuration conf = cluster.getConfiguration();
            atts = new AttributesImpl();
            atts.addAttribute("", "type", "type", "CDATA", "jgroups");
            this.contentHandler.startElement(NAMESPACE, "info", "cluster:info", atts);
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "protocol");
            String protocol = (String)conf.getProperty("cluster.protocol");
            if (protocol == null) {
                protocol = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32;loopback=true):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
            }
            StringBuffer prot = new StringBuffer();
            for (int i = 0; i < protocol.length(); i += 70) {
                prot.append(protocol.substring(i, Math.min(i + 70, protocol.length())));
                prot.append(" ");
            }
            inner.addAttribute("", "value", "value", "CDATA", prot.toString());
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            this.contentHandler.endElement(NAMESPACE, "info", "cluster:info");
            atts = new AttributesImpl();
            atts.addAttribute("", "type", "type", "CDATA", "journal");
            this.contentHandler.startElement(NAMESPACE, "info", "cluster:info", atts);
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "journal-dir");
            inner.addAttribute("", "value", "value", "CDATA", "" + conf.getProperty("cluster.journalDir"));
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "exclude-dir");
            inner.addAttribute("", "value", "value", "CDATA", "" + conf.getProperty("cluster.exclude"));
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "max-item");
            inner.addAttribute("", "value", "value", "CDATA", "" + conf.getProperty("cluster.journal.maxStore"));
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            inner = new AttributesImpl();
            inner.addAttribute("", "name", "name", "CDATA", "coordinator-shift");
            inner.addAttribute("", "value", "value", "CDATA", "" + conf.getProperty("cluster.journal.shift"));
            this.contentHandler.startElement(NAMESPACE, "data", "cluster:data", inner);
            this.contentHandler.endElement(NAMESPACE, "data", "cluster:data");
            this.contentHandler.endElement(NAMESPACE, "info", "cluster:info");
        }
        catch (ClusterException e) {
            e.printStackTrace();
            throw new SAXException("ERROR CREATING INFOS ", e);
        }
    }

    private void addValue(String elem, String value) throws SAXException {
        this.stats.addValue(elem, value);
    }
}

