/*
 * Decompiled with CFR 0.152.
 */
package org.exist.cluster.journal;

import java.util.HashMap;
import org.exist.cluster.journal.JournalManager;

public class JournalIdGenerator {
    public static int MAX_STORED_INDEX = 65000;
    private int lastId = -1;
    private int counter = 0;
    private HashMap idInUse = new HashMap();

    public JournalIdGenerator(JournalManager journal, int maxItem) {
        System.out.println("MAX STORE IN ID GENERATOR = " + maxItem);
        this.lastId = journal.getMaxIdSaved();
        this.counter = journal.getCounter();
        MAX_STORED_INDEX = maxItem;
    }

    public synchronized int[] getNextData(String address) {
        ++this.lastId;
        if (this.lastId > MAX_STORED_INDEX) {
            this.lastId = 0;
        }
        this.idInUse.put("" + this.lastId, address);
        return new int[]{this.lastId, ++this.counter};
    }

    public void setLastId(int lastId) {
        this.lastId = lastId;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void releaseId(int id) {
        this.idInUse.remove("" + id);
    }

    public synchronized void increaseId(int id, int counter) {
        if (id > this.lastId || this.counter != counter) {
            this.lastId = id;
            this.counter = counter;
        }
    }

    public int[] getData() {
        return new int[]{this.lastId, this.counter};
    }

    public synchronized void shiftId(int shift) {
        this.lastId += shift;
        if (this.lastId > MAX_STORED_INDEX) {
            this.lastId -= MAX_STORED_INDEX;
            ++this.counter;
        }
    }
}

