/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NamedNode;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.Signatures;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.exist.util.pool.NodePool;
import org.exist.util.serializer.AttrList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class AttrImpl
extends NamedNode
implements Attr {
    public static final int LENGTH_NS_ID = 2;
    public static final int LENGTH_PREFIX_LENGTH = 2;
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int DEFAULT_ATTRIBUTE_TYPE = 0;
    protected int attributeType = 0;
    protected XMLString value = null;

    public AttrImpl() {
        super((short)2);
    }

    public AttrImpl(QName name) {
        super((short)2, name);
    }

    public AttrImpl(QName name, XMLString value) {
        super((short)2, name);
        this.value = value;
    }

    public AttrImpl(QName name, String str) {
        super((short)2, name);
        this.value = new XMLString(str.toCharArray());
    }

    public AttrImpl(AttrImpl other) {
        super(other);
        this.attributeType = other.attributeType;
        this.value = other.value;
    }

    public void clear() {
        super.clear();
        this.attributeType = 0;
        this.value = null;
    }

    public byte[] serialize() {
        if (this.nodeName.getLocalName() == null) {
            throw new RuntimeException("Local name is null");
        }
        short id = this.ownerDocument.getBrokerPool().getSymbols().getSymbol(this);
        byte idSizeType = Signatures.getSizeType(id);
        int prefixLen = 0;
        if (this.nodeName.needsNamespaceDecl() && this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
            prefixLen = UTF8.encoded(this.nodeName.getPrefix());
        }
        int nodeIdLen = this.nodeId.size();
        byte[] data = ByteArrayPool.getByteArray(3 + nodeIdLen + Signatures.getLength(idSizeType) + (this.nodeName.needsNamespaceDecl() ? 4 + prefixLen : 0) + this.value.UTF8Size());
        int pos = 0;
        data[pos] = -128;
        int n = pos;
        data[n] = (byte)(data[n] | idSizeType);
        int n2 = pos;
        data[n2] = (byte)(data[n2] | (byte)(this.attributeType << 2));
        if (this.nodeName.needsNamespaceDecl()) {
            int n3 = pos;
            data[n3] = (byte)(data[n3] | 0x10);
        }
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        Signatures.write(idSizeType, id, data, pos += nodeIdLen);
        pos += Signatures.getLength(idSizeType);
        if (this.nodeName.needsNamespaceDecl()) {
            short nsId = this.ownerDocument.getBrokerPool().getSymbols().getNSSymbol(this.nodeName.getNamespaceURI());
            ByteConversion.shortToByte(nsId, data, pos);
            ByteConversion.shortToByte((short)prefixLen, data, pos += 2);
            pos += 2;
            if (this.nodeName.getPrefix() != null && this.nodeName.getPrefix().length() > 0) {
                UTF8.encode(this.nodeName.getPrefix(), data, pos);
            }
            pos += prefixLen;
        }
        this.value.UTF8Encode(data, pos);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int attrType = (data[pos] & 4) >> 2;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short id = (short)Signatures.read(idSizeType, data, pos += dln.size());
        pos += Signatures.getLength(idSizeType);
        String name = doc.getBrokerPool().getSymbols().getName(id);
        if (name == null) {
            throw new RuntimeException("no symbol for id " + id);
        }
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String namespace = nsId == 0 ? "" : doc.getBrokerPool().getSymbols().getNamespace(nsId);
        XMLString value = UTF8.decode(data, pos, len - (pos - start));
        AttrImpl attr = pooled ? (AttrImpl)NodePool.getInstance().borrowNode((short)2) : new AttrImpl();
        attr.setNodeName(doc.getBrokerPool().getSymbols().getQName((short)2, namespace, name, prefix));
        attr.value = value;
        attr.setNodeId(dln);
        if (dln == null) {
            throw new RuntimeException("no node id " + id);
        }
        attr.setType(attrType);
        return attr;
    }

    public static void addToList(DBBroker broker, byte[] data, int start, int len, AttrList list) {
        String value;
        int pos = start;
        byte idSizeType = (byte)(data[pos] & 3);
        boolean hasNamespace = (data[pos] & 0x10) == 16;
        int attrType = (data[pos] & 4) >> 2;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = broker.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        short id = (short)Signatures.read(idSizeType, data, pos += dln.size());
        pos += Signatures.getLength(idSizeType);
        String name = broker.getBrokerPool().getSymbols().getName(id);
        if (name == null) {
            throw new RuntimeException("no symbol for id " + id);
        }
        short nsId = 0;
        String prefix = null;
        if (hasNamespace) {
            nsId = ByteConversion.byteToShort(data, pos);
            short prefixLen = ByteConversion.byteToShort(data, pos += 2);
            pos += 2;
            if (prefixLen > 0) {
                prefix = UTF8.decode(data, pos, prefixLen).toString();
            }
            pos += prefixLen;
        }
        String namespace = nsId == 0 ? "" : broker.getBrokerPool().getSymbols().getNamespace(nsId);
        try {
            value = new String(data, pos, len - (pos - start), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            value = new String(data, pos, len - (pos - start));
        }
        list.addAttribute(broker.getBrokerPool().getSymbols().getQName((short)2, namespace, name, prefix), value, attrType);
    }

    public String getName() {
        return this.nodeName.getStringValue();
    }

    public int getType() {
        return this.attributeType;
    }

    public void setType(int type) {
        this.attributeType = type;
    }

    public String getValue() {
        return this.value.toString();
    }

    public String getNodeValue() {
        return this.value.toString();
    }

    public void setValue(String str) throws DOMException {
        this.value = new XMLString(str.toCharArray());
    }

    public Element getOwnerElement() {
        return (Element)((DocumentImpl)this.getOwnerDocument()).getNode(this.nodeId.getParentId());
    }

    public boolean getSpecified() {
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(' ');
        buf.append(this.nodeName);
        buf.append("=\"");
        buf.append(this.value);
        buf.append('\"');
        return buf.toString();
    }

    public String toString(boolean top) {
        if (top) {
            StringBuffer result = new StringBuffer();
            result.append("<exist:attribute ");
            result.append("xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
            result.append("exist:id=\"");
            result.append(this.getNodeId());
            result.append("\" exist:source=\"");
            result.append(((DocumentImpl)this.getOwnerDocument()).getFileURI());
            result.append("\" ");
            result.append(this.getNodeName());
            result.append("=\"");
            result.append(this.getValue());
            result.append("\"/>");
            return result.toString();
        }
        return this.toString();
    }

    public boolean hasChildNodes() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getFirstChild() {
        return null;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public boolean isId() {
        return this.getType() == 1;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }
}

