/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.EOFException;
import java.io.IOException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.security.Group;
import org.exist.security.SecurityManager;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.xmldb.XmldbURI;

public class BinaryDocument
extends DocumentImpl {
    private long pageNr = -1L;
    private int realSize = 0;

    public BinaryDocument(BrokerPool pool) {
        super(pool, null, null);
    }

    public BinaryDocument(BrokerPool pool, Collection collection) {
        super(pool, collection);
    }

    public BinaryDocument(BrokerPool pool, XmldbURI fileURI) {
        super(pool, null, fileURI);
    }

    public BinaryDocument(BrokerPool pool, Collection collection, XmldbURI fileURI) {
        super(pool, collection, fileURI);
    }

    public byte getResourceType() {
        return 1;
    }

    public void setPage(long page) {
        this.pageNr = page;
    }

    public long getPage() {
        return this.pageNr;
    }

    public int getContentLength() {
        return this.realSize;
    }

    public void setContentLength(int length) {
        this.realSize = length;
    }

    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeInt(this.getDocId());
        ostream.writeUTF(this.getFileURI().toString());
        ostream.writeLong(this.pageNr);
        SecurityManager secman = this.getBrokerPool().getSecurityManager();
        if (secman == null) {
            ostream.writeInt(1);
            ostream.writeInt(1);
        } else {
            User user = secman.getUser(this.permissions.getOwner());
            Group group = secman.getGroup(this.permissions.getOwnerGroup());
            ostream.writeInt(user.getUID());
            ostream.writeInt(group.getId());
        }
        ostream.writeByte((byte)this.permissions.getPermissions());
        ostream.writeInt(this.realSize);
        this.getMetadata().write(this.getBrokerPool(), ostream);
    }

    public void read(VariableByteInput istream) throws IOException, EOFException {
        this.setDocId(istream.readInt());
        this.setFileURI(XmldbURI.create(istream.readUTF()));
        this.pageNr = istream.readLong();
        SecurityManager secman = this.getBrokerPool().getSecurityManager();
        int uid = istream.readInt();
        int groupId = istream.readInt();
        int perm = istream.readByte() & 0x1FF;
        if (secman == null) {
            this.permissions.setOwner("admin");
            this.permissions.setGroup("dba");
        } else {
            this.permissions.setOwner(secman.getUser(uid));
            Group group = secman.getGroup(groupId);
            if (group != null) {
                this.permissions.setGroup(group.getName());
            }
        }
        this.permissions.setPermissions(perm);
        this.realSize = istream.readInt();
        DocumentMetadata metadata = new DocumentMetadata();
        metadata.read(this.getBrokerPool(), istream);
        this.setMetadata(metadata);
    }
}

