/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Arrays;
import java.util.Iterator;
import org.exist.dom.AbstractNodeSet;
import org.exist.dom.ByDocumentIterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.VirtualNodeSet;
import org.exist.numbering.NodeId;
import org.exist.util.ArrayUtils;
import org.exist.util.FastQSort;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;

public class ExtArrayNodeSet
extends AbstractNodeSet
implements ExtNodeSet {
    private static final int INITIAL_DOC_SIZE = 64;
    private int[] documentIds;
    private Part[] parts;
    protected int initalSize = 128;
    protected int size = 0;
    private int partCount = 0;
    private boolean isSorted = false;
    private boolean hasOne = false;
    protected int lastDoc = -1;
    protected Part lastPart = null;
    protected NodeProxy lastAdded = null;
    private int state = 0;
    private DocumentSet cachedDocuments = null;
    private int itemType = 12;

    public ExtArrayNodeSet() {
        this.documentIds = new int[64];
        this.parts = new Part[64];
        Arrays.fill(this.documentIds, 0);
    }

    public ExtArrayNodeSet(int initialDocsCount, int initialArraySize) {
        this.initalSize = initialArraySize;
        if (initialDocsCount == 0) {
            initialDocsCount = 1;
        }
        this.documentIds = new int[initialDocsCount];
        this.parts = new Part[initialDocsCount];
        Arrays.fill(this.documentIds, 0);
    }

    public ExtArrayNodeSet(int initialArraySize) {
        this.initalSize = initialArraySize;
        this.documentIds = new int[64];
        this.parts = new Part[64];
        Arrays.fill(this.documentIds, 0);
    }

    protected Part getPart(DocumentImpl doc, boolean create, int sizeHint) {
        if (this.lastPart != null && doc.getDocId() == this.lastDoc) {
            return this.lastPart;
        }
        int idx = ArrayUtils.binarySearch(this.documentIds, doc.getDocId(), this.partCount);
        Part part = null;
        if (idx >= 0) {
            part = this.parts[idx];
        } else if (create) {
            idx = -(idx + 1);
            part = new Part(sizeHint);
            this.insertPart(doc.getDocId(), part, idx);
        }
        return part;
    }

    public void reset() {
        for (int i = 0; i < this.partCount; ++i) {
            this.parts[i] = null;
            this.documentIds[i] = 0;
        }
        this.size = 0;
        this.partCount = 0;
        this.isSorted = false;
        this.lastPart = null;
        this.lastDoc = -1;
        this.state = 0;
    }

    private void insertPart(int docId, Part part, int idx) {
        if (this.partCount == this.parts.length) {
            int nsize = this.parts.length == 0 ? 1 : this.parts.length * 2;
            int[] ndocs = new int[nsize];
            System.arraycopy(this.documentIds, 0, ndocs, 0, this.documentIds.length);
            Arrays.fill(this.documentIds, -1);
            Part[] nparts = new Part[nsize];
            System.arraycopy(this.parts, 0, nparts, 0, this.parts.length);
            this.documentIds = ndocs;
            this.parts = nparts;
        }
        if (idx == this.partCount) {
            this.documentIds[idx] = docId;
            this.parts[idx] = part;
        } else {
            System.arraycopy(this.documentIds, idx, this.documentIds, idx + 1, this.partCount - idx);
            System.arraycopy(this.parts, idx, this.parts, idx + 1, this.partCount - idx);
            this.documentIds[idx] = docId;
            this.parts[idx] = part;
        }
        ++this.partCount;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean hasOne() {
        return this.hasOne;
    }

    public void add(NodeProxy proxy) {
        if (this.size > 0) {
            if (this.hasOne) {
                this.hasOne = this.isSorted ? this.get(proxy) != null : this.lastAdded == null || this.lastAdded.compareTo(proxy) == 0;
            }
        } else {
            this.hasOne = true;
        }
        this.getPart(proxy.getDocument(), true, this.initalSize).add(proxy);
        ++this.size;
        this.isSorted = false;
        this.setHasChanged();
        this.checkItemType(proxy.getType());
        this.lastAdded = proxy;
    }

    public void add(NodeProxy proxy, int sizeHint) {
        if (this.size > 0) {
            if (this.hasOne) {
                this.hasOne = this.isSorted ? this.get(proxy) == null : this.lastAdded == null || this.lastAdded.compareTo(proxy) == 0;
            }
        } else {
            this.hasOne = true;
        }
        this.getPart(proxy.getDocument(), true, sizeHint != -1 ? sizeHint : this.initalSize).add(proxy);
        ++this.size;
        this.isSorted = false;
        this.setHasChanged();
        this.checkItemType(proxy.getType());
        this.lastAdded = proxy;
    }

    private void checkItemType(int type) {
        if (this.itemType == -1 || this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : -1;
    }

    public int getItemType() {
        return this.itemType;
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? (this.state = 0) : this.state + 1;
        this.cachedDocuments = null;
    }

    public int getSizeHint(DocumentImpl doc) {
        Part part = this.getPart(doc, false, 0);
        return part == null ? -1 : part.length;
    }

    public NodeSetIterator iterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new ExtArrayIterator();
    }

    public SequenceIterator iterate() throws XPathException {
        this.sortInDocumentOrder();
        return new ExtArrayIterator();
    }

    public SequenceIterator unorderedIterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new ExtArrayIterator();
    }

    public ByDocumentIterator iterateByDocument() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new ExtDocIterator();
    }

    public boolean contains(NodeProxy proxy) {
        Part part = this.getPart(proxy.getDocument(), false, 0);
        return part == null ? false : part.contains(proxy.getNodeId());
    }

    public void addAll(NodeSet other) {
        if (other.isEmpty()) {
            return;
        }
        if (other.hasOne()) {
            this.add((NodeProxy)other.itemAt(0));
        } else {
            NodeSetIterator i = other.iterator();
            while (i.hasNext()) {
                this.add((NodeProxy)i.next());
            }
        }
    }

    public int getLength() {
        if (!this.isSorted()) {
            this.sort();
        }
        return this.size;
    }

    public int getItemCount() {
        if (!this.isSorted()) {
            this.sort();
        }
        return this.size;
    }

    public Node item(int pos) {
        this.sortInDocumentOrder();
        NodeProxy p = this.get(pos);
        return p == null ? null : p.getNode();
    }

    public NodeProxy get(int pos) {
        int count = 0;
        for (int i = 0; i < this.partCount; ++i) {
            Part part = this.parts[i];
            if (count + part.length > pos) {
                return part.get(pos - count);
            }
            count += part.length;
        }
        return null;
    }

    public NodeProxy get(NodeProxy p) {
        Part part = this.getPart(p.getDocument(), false, 0);
        return part == null ? null : part.get(p.getNodeId());
    }

    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.sort();
        Part part = this.getPart(doc, false, 0);
        return part == null ? null : part.get(nodeId);
    }

    public Item itemAt(int pos) {
        this.sortInDocumentOrder();
        return this.get(pos);
    }

    public NodeSet getDescendantsInSet(NodeSet al, boolean childOnly, boolean includeSelf, int mode, int contextId) {
        this.sort();
        ExtArrayNodeSet result = new ExtArrayNodeSet();
        NodeSetIterator i = al.iterator();
        while (i.hasNext()) {
            NodeProxy node = (NodeProxy)i.next();
            Part part = this.getPart(node.getDocument(), false, 0);
            if (part == null) continue;
            part.getDescendantsInSet(result, node, childOnly, includeSelf, mode, contextId);
        }
        return result;
    }

    public NodeProxy hasDescendantsInSet(DocumentImpl doc, NodeId ancestorId, boolean includeSelf, int contextId) {
        this.sort();
        Part part = this.getPart(doc, false, 0);
        return part == null ? null : part.hasDescendantsInSet(ancestorId, contextId, includeSelf);
    }

    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectParentChild(al, mode, contextId);
        }
        return this.getDescendantsInSet(al, true, false, mode, contextId);
    }

    public NodeSet filterDocuments(ExtArrayNodeSet otherSet) {
        ExtArrayNodeSet other = otherSet;
        ExtArrayNodeSet result = new ExtArrayNodeSet(this.partCount, other.initalSize);
        for (int i = 0; i < other.partCount; ++i) {
            int idx = ArrayUtils.binarySearch(this.documentIds, other.documentIds[i], this.partCount);
            if (idx <= -1) continue;
            Part part = this.parts[idx];
            int otherIdx = ArrayUtils.binarySearch(result.documentIds, this.documentIds[idx], result.partCount);
            otherIdx = -(otherIdx + 1);
            result.insertPart(this.documentIds[idx], part, otherIdx);
        }
        return result;
    }

    private boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(DocumentImpl document, boolean sorted) {
        Part part = this.getPart(document, false, -1);
        if (part != null) {
            part.setIsSorted(sorted);
        }
    }

    public void mergeDuplicates() {
        this.sort(true);
    }

    public void sort() {
        this.sort(false);
    }

    public void sort(boolean mergeContexts) {
        if (this.isSorted) {
            return;
        }
        if (this.hasOne) {
            this.isSorted = true;
            this.size = this.parts[0].removeDuplicates(mergeContexts);
            return;
        }
        this.size = 0;
        for (int i = 0; i < this.partCount; ++i) {
            Part part = this.parts[i];
            part.sort();
            this.size += part.removeDuplicates(mergeContexts);
        }
        this.isSorted = true;
    }

    public final void sortInDocumentOrder() {
        this.sort(false);
    }

    public void setSelfAsContext(int contextId) {
        for (int i = 0; i < this.partCount; ++i) {
            this.parts[i].setSelfAsContext(contextId);
        }
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectAncestorDescendant(al, mode, includeSelf, contextId);
        }
        return this.getDescendantsInSet(al, false, includeSelf, mode, contextId);
    }

    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectPrecedingSiblings(siblings, contextId);
    }

    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectFollowingSiblings(siblings, contextId);
    }

    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, int contextId) {
        this.sort();
        return super.selectAncestors(al, includeSelf, contextId);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        this.sort();
        this.lastPart = this.getPart(doc, false, this.initalSize);
        return this.lastPart == null ? null : this.lastPart.parentWithChild(doc, nodeId, directParent, includeSelf);
    }

    public String debugParts() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.partCount; ++i) {
            buf.append(this.documentIds[i]);
            buf.append(' ');
        }
        return buf.toString();
    }

    public int getIndexType() {
        if (this.indexType == 12) {
            this.hasTextIndex = false;
            this.hasMixedContent = false;
            for (int i = 0; i < this.partCount; ++i) {
                this.parts[i].determineIndexType();
            }
        }
        return this.indexType;
    }

    public DocumentSet getDocumentSet() {
        if (this.cachedDocuments != null) {
            return this.cachedDocuments;
        }
        this.cachedDocuments = new DocumentSet(this.partCount);
        this.sort();
        for (int i = 0; i < this.partCount; ++i) {
            this.cachedDocuments.add(this.parts[i].getDocument(), false);
        }
        this.isSorted = true;
        return this.cachedDocuments;
    }

    public void setDocumentSet(DocumentSet docs) {
        this.cachedDocuments = docs;
    }

    public Iterator getCollectionIterator() {
        return new CollectionIterator();
    }

    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    public int getState() {
        return this.state;
    }

    public boolean isCacheable() {
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ExtArrayTree#").append(super.toString());
        return result.toString();
    }

    private class ExtDocIterator
    implements ByDocumentIterator {
        Part currentPart = null;
        int pos = 0;
        NodeProxy next = null;

        public ExtDocIterator() {
            if (ExtArrayNodeSet.this.partCount > 0) {
                this.currentPart = ExtArrayNodeSet.this.parts[0];
            }
            if (this.currentPart != null && this.currentPart.length > 0) {
                this.next = this.currentPart.get(0);
            }
        }

        public void nextDocument(DocumentImpl document) {
            this.currentPart = ExtArrayNodeSet.this.getPart(document, false, -1);
            this.pos = 0;
            this.next = this.currentPart != null && this.currentPart.length > 0 ? this.currentPart.get(0) : null;
        }

        public boolean hasNextNode() {
            return this.next != null;
        }

        public NodeProxy nextNode() {
            if (this.next == null) {
                return null;
            }
            NodeProxy n = this.next;
            this.next = null;
            if (++this.pos < this.currentPart.length) {
                this.next = this.currentPart.get(this.pos);
            }
            return n;
        }

        public NodeProxy peekNode() {
            return this.next;
        }

        public void setPosition(NodeProxy node) {
            this.currentPart = ExtArrayNodeSet.this.getPart(node.getDocument(), false, -1);
            int low = 0;
            int high = this.currentPart.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                NodeProxy p = this.currentPart.array[mid];
                int cmp = p.getNodeId().compareTo(node.getNodeId());
                if (cmp == 0) {
                    this.pos = mid;
                    this.next = p;
                    return;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            this.next = null;
        }
    }

    private class ExtArrayIterator
    implements NodeSetIterator,
    SequenceIterator {
        Part currentPart = null;
        int partPos = 0;
        int pos = 0;
        NodeProxy next = null;

        ExtArrayIterator() {
            if (this.partPos < ExtArrayNodeSet.this.partCount) {
                this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
            }
            if (this.currentPart != null && this.currentPart.length > 0) {
                this.next = this.currentPart.get(0);
            }
        }

        public void setPosition(NodeProxy proxy) {
            this.partPos = ArrayUtils.binarySearch(ExtArrayNodeSet.this.documentIds, proxy.getDocument().getDocId(), ExtArrayNodeSet.this.partCount);
            if (this.partPos >= 0) {
                this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
                int low = 0;
                int high = this.currentPart.length - 1;
                while (low <= high) {
                    int mid = (low + high) / 2;
                    NodeProxy p = this.currentPart.array[mid];
                    int cmp = p.getNodeId().compareTo(proxy.getNodeId());
                    if (cmp == 0) {
                        this.pos = mid;
                        this.next = p;
                        return;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
            }
            this.next = null;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                return null;
            }
            NodeProxy n = this.next;
            this.next = null;
            if (++this.pos == this.currentPart.length) {
                if (++this.partPos < ExtArrayNodeSet.this.partCount) {
                    this.currentPart = ExtArrayNodeSet.this.parts[this.partPos];
                    if (this.currentPart != null && this.currentPart.length > 0) {
                        this.next = this.currentPart.get(0);
                        this.pos = 0;
                    }
                }
            } else {
                this.next = this.currentPart.get(this.pos);
            }
            return n;
        }

        public NodeProxy peekNode() {
            return this.next;
        }

        public Item nextItem() {
            return (Item)this.next();
        }

        public void remove() {
        }
    }

    private final class Part {
        private boolean isSorted = false;
        private NodeProxy[] array;
        private int length = 0;

        Part(int initialSize) {
            this.array = new NodeProxy[initialSize];
        }

        public void selectParentChild(NodeSet result, NodeProxy na, NodeSetIterator ia, int mode, int contextId) {
            if (this.length == 0) {
                return;
            }
            int pos = 0;
            int startPos = 0;
            NodeProxy nb = this.array[pos];
            NodeId lastMarked = na.getNodeId();
            while (na.getDocument().getDocId() == nb.getDocument().getDocId()) {
                NodeProxy next;
                NodeId pa = na.getNodeId();
                NodeId pb = nb.getNodeId();
                int relation = pb.computeRelation(pa);
                if (relation != -1) {
                    NodeProxy next2;
                    if (relation == 1) {
                        if (mode == 1) {
                            if (-1 != contextId) {
                                nb.addContextNode(contextId, na);
                            } else {
                                nb.copyContext(na);
                            }
                            result.add(nb);
                        } else {
                            if (-1 != contextId) {
                                na.addContextNode(contextId, nb);
                            } else {
                                na.copyContext(nb);
                            }
                            result.add(na);
                        }
                    }
                    if (++pos < this.length) {
                        nb = this.array[pos];
                        continue;
                    }
                    if (!ia.hasNext() || !(next2 = ia.peekNode()).getNodeId().isDescendantOf(pa)) break;
                    pos = startPos;
                    nb = this.array[pos];
                    na = (NodeProxy)ia.next();
                    startPos = pos;
                    continue;
                }
                int cmp = pa.compareTo(pb);
                if (cmp < 0) {
                    if (!ia.hasNext()) break;
                    next = (NodeProxy)ia.next();
                    if (next.getNodeId().isDescendantOf(pa)) {
                        pos = startPos;
                        nb = this.array[pos];
                    } else if (!next.getNodeId().isDescendantOf(lastMarked)) {
                        lastMarked = next.getNodeId();
                        startPos = pos;
                    }
                    na = next;
                    continue;
                }
                if (++pos < this.length) {
                    nb = this.array[pos];
                    continue;
                }
                if (!ia.hasNext()) continue;
                next = (NodeProxy)ia.next();
                if (next.getNodeId().isDescendantOf(pa)) {
                    pos = startPos;
                    nb = this.array[pos];
                }
                na = next;
            }
        }

        void add(NodeProxy p) {
            if (this.length > 0 && this.array[this.length - 1].getNodeId().equals(p.getNodeId())) {
                this.array[this.length - 1].addMatches(p);
                return;
            }
            if (this.length == this.array.length) {
                int newLength = this.length << 1;
                NodeProxy[] temp = new NodeProxy[newLength];
                System.arraycopy(this.array, 0, temp, 0, this.length);
                this.array = temp;
            }
            this.array[this.length++] = p;
        }

        boolean contains(NodeId nodeId) {
            return this.get(nodeId) != null;
        }

        NodeProxy get(int pos) {
            return this.array[pos];
        }

        NodeProxy get(NodeId nodeId) {
            int low = 0;
            int high = this.length - 1;
            while (low <= high) {
                int mid = (low + high) / 2;
                NodeProxy p = this.array[mid];
                int cmp = p.getNodeId().compareTo(nodeId);
                if (cmp == 0) {
                    return p;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            return null;
        }

        DocumentImpl getDocument() {
            if (this.length == 0) {
                return null;
            }
            return this.array[0].getDocument();
        }

        void setIsSorted(boolean sorted) {
            this.isSorted = sorted;
        }

        void sort() {
            if (this.isSorted) {
                return;
            }
            FastQSort.sortByNodeId(this.array, 0, this.length - 1);
        }

        void sortInDocumentOrder() {
            this.sort();
        }

        NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
            NodeProxy temp;
            if (includeSelf && (temp = this.get(nodeId)) != null) {
                return temp;
            }
            for (nodeId = nodeId.getParentId(); nodeId != null; nodeId = nodeId.getParentId()) {
                temp = this.get(nodeId);
                if (temp != null) {
                    return temp;
                }
                if (!directParent) continue;
                return null;
            }
            return null;
        }

        NodeProxy hasDescendantsInSet(NodeId ancestorId, int contextId, boolean includeSelf) {
            int cmp;
            NodeId id;
            int low = 0;
            int high = this.length - 1;
            int mid = 0;
            while (low <= high && !(id = this.array[mid = (low + high) / 2].getNodeId()).isDescendantOrSelfOf(ancestorId)) {
                cmp = id.compareTo(ancestorId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return null;
            }
            while (mid > 0 && this.array[mid - 1].getNodeId().compareTo(ancestorId) >= 0) {
                --mid;
            }
            NodeProxy ancestor = new NodeProxy(this.getDocument(), ancestorId, 1);
            boolean foundOne = false;
            for (int i = mid; i < this.length && (cmp = this.array[i].getNodeId().computeRelation(ancestorId)) > -1; ++i) {
                boolean add = true;
                if (cmp == 3) {
                    add = includeSelf;
                }
                if (!add) continue;
                if (-1 != contextId) {
                    ancestor.deepCopyContext(this.array[i], contextId);
                } else {
                    ancestor.copyContext(this.array[i]);
                }
                ancestor.addMatches(this.array[i]);
                foundOne = true;
            }
            return foundOne ? ancestor : null;
        }

        NodeSet getDescendantsInSet(NodeSet result, NodeProxy parent, boolean childOnly, boolean includeSelf, int mode, int contextId) {
            NodeId parentId = parent.getNodeId();
            if (parentId == NodeId.DOCUMENT_NODE) {
                block8: for (int i = 0; i < this.length; ++i) {
                    boolean add;
                    if (childOnly) {
                        add = this.array[i].getNodeId().getTreeLevel() == 1;
                    } else if (includeSelf) {
                        add = true;
                    } else {
                        boolean bl = add = this.array[i].getNodeId() != NodeId.DOCUMENT_NODE;
                    }
                    if (!add) continue;
                    switch (mode) {
                        case 1: {
                            if (-1 != contextId) {
                                this.array[i].deepCopyContext(parent, contextId);
                            } else {
                                this.array[i].copyContext(parent);
                            }
                            this.array[i].addMatches(parent);
                            result.add(this.array[i]);
                            continue block8;
                        }
                        case 0: {
                            if (-1 != contextId) {
                                parent.deepCopyContext(this.array[i], contextId);
                            } else {
                                parent.copyContext(this.array[i]);
                            }
                            parent.addMatches(this.array[i]);
                            result.add(parent, 1);
                        }
                    }
                }
            } else {
                int cmp;
                NodeProxy p;
                int low = 0;
                int high = this.length - 1;
                int mid = 0;
                while (low <= high && !(p = this.array[mid = (low + high) / 2]).getNodeId().isDescendantOrSelfOf(parentId)) {
                    cmp = p.getNodeId().compareTo(parentId);
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
                if (low > high) {
                    return result;
                }
                while (mid > 0 && this.array[mid - 1].getNodeId().compareTo(parentId) > -1) {
                    --mid;
                }
                block11: for (int i = mid; i < this.length && (cmp = this.array[i].getNodeId().computeRelation(parentId)) > -1; ++i) {
                    boolean add = true;
                    if (childOnly) {
                        add = cmp == 1;
                    } else if (cmp == 3) {
                        add = includeSelf;
                    }
                    if (!add) continue;
                    switch (mode) {
                        case 1: {
                            if (-1 != contextId) {
                                this.array[i].deepCopyContext(parent, contextId);
                            } else {
                                this.array[i].copyContext(parent);
                            }
                            this.array[i].addMatches(parent);
                            result.add(this.array[i]);
                            continue block11;
                        }
                        case 0: {
                            if (-1 != contextId) {
                                parent.deepCopyContext(this.array[i], contextId);
                            } else {
                                parent.copyContext(this.array[i]);
                            }
                            parent.addMatches(this.array[i]);
                            result.add(parent, 1);
                        }
                    }
                }
            }
            return result;
        }

        int removeDuplicates(boolean mergeContext) {
            int j = 0;
            for (int i = 1; i < this.length; ++i) {
                if (!this.array[i].getNodeId().equals(this.array[j].getNodeId())) {
                    if (i == ++j) continue;
                    this.array[j] = this.array[i];
                    continue;
                }
                if (mergeContext) {
                    this.array[j].addContext(this.array[i]);
                }
                this.array[j].addMatches(this.array[i]);
            }
            this.length = ++j;
            return this.length;
        }

        void determineIndexType() {
            if (ExtArrayNodeSet.this.indexType == 12) {
                ExtArrayNodeSet.this.hasTextIndex = true;
                ExtArrayNodeSet.this.hasMixedContent = true;
                for (int i = 0; i < this.length; ++i) {
                    NodeProxy node = this.array[i];
                    if (node.getDocument().getCollection().isTempCollection()) {
                        ExtArrayNodeSet.this.indexType = 11;
                        ExtArrayNodeSet.this.hasTextIndex = false;
                        ExtArrayNodeSet.this.hasMixedContent = false;
                        break;
                    }
                    int nodeIndexType = node.getIndexType();
                    if (ExtArrayNodeSet.this.indexType == 12) {
                        ExtArrayNodeSet.this.indexType = nodeIndexType;
                    } else if (ExtArrayNodeSet.this.indexType != nodeIndexType) {
                        ExtArrayNodeSet.this.indexType = 11;
                    }
                    if (!node.hasTextIndex()) {
                        ExtArrayNodeSet.this.hasTextIndex = false;
                    }
                    if (node.hasMixedContent()) continue;
                    ExtArrayNodeSet.this.hasMixedContent = false;
                }
            }
        }

        void setSelfAsContext(int contextId) {
            for (int i = 0; i < this.length; ++i) {
                this.array[i].addContextNode(contextId, this.array[i]);
            }
        }
    }

    private class CollectionIterator
    implements Iterator {
        Iterator iterator = null;

        CollectionIterator() {
            if (ExtArrayNodeSet.this.partCount > 0) {
                ObjectHashSet collections = new ObjectHashSet();
                for (int i = 0; i < ExtArrayNodeSet.this.partCount; ++i) {
                    Part part = ExtArrayNodeSet.this.parts[i];
                    collections.add(part.getDocument().getCollection());
                }
                this.iterator = collections.iterator();
            }
        }

        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

