/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.numbering.NodeId;

public abstract class Match
implements Comparable {
    private int context;
    private NodeId nodeId;
    private String matchTerm;
    private int[] offsets;
    private int[] lengths;
    private int currentOffset = 0;
    protected Match nextMatch = null;

    protected Match(int contextId, NodeId nodeId, String matchTerm) {
        this(contextId, nodeId, matchTerm, 1);
    }

    protected Match(int contextId, NodeId nodeId, String matchTerm, int frequency) {
        this.context = contextId;
        this.nodeId = nodeId;
        this.matchTerm = matchTerm;
        this.offsets = new int[frequency];
        this.lengths = new int[frequency];
    }

    protected Match(Match match) {
        this.context = match.context;
        this.nodeId = match.nodeId;
        this.matchTerm = match.matchTerm;
        this.offsets = match.offsets;
        this.lengths = match.lengths;
        this.currentOffset = match.currentOffset;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getFrequency() {
        return this.currentOffset;
    }

    public String getMatchTerm() {
        return this.matchTerm;
    }

    public int getContextId() {
        return this.context;
    }

    public abstract Match createInstance(int var1, NodeId var2, String var3);

    public abstract Match newCopy();

    public abstract String getIndexId();

    public void addOffset(int offset, int length) {
        if (this.currentOffset == this.offsets.length) {
            int[] noffsets = new int[this.currentOffset + 1];
            System.arraycopy(this.offsets, 0, noffsets, 0, this.currentOffset);
            this.offsets = noffsets;
            int[] nlengths = new int[this.currentOffset + 1];
            System.arraycopy(this.lengths, 0, nlengths, 0, this.currentOffset);
            this.lengths = nlengths;
        }
        this.offsets[this.currentOffset] = offset;
        this.lengths[this.currentOffset++] = length;
    }

    public Offset getOffset(int pos) {
        return new Offset(this.offsets[pos], this.lengths[pos]);
    }

    public Match isAfter(Match other) {
        Match m = null;
        for (int i = 0; i < this.currentOffset; ++i) {
            for (int j = 0; j < other.currentOffset; ++j) {
                if (other.offsets[j] <= this.offsets[i] || other.offsets[j] > this.offsets[i] + this.lengths[i]) continue;
                if (m == null) {
                    m = this.createInstance(this.context, this.nodeId, this.matchTerm + other.matchTerm);
                }
                m.addOffset(this.offsets[i], this.lengths[i] + other.lengths[j]);
            }
        }
        return m;
    }

    public boolean hasMatchAt(int pos) {
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] != pos) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchAround(int pos) {
        for (int i = 0; i < this.currentOffset; ++i) {
            if (this.offsets[i] + this.lengths[i] < pos) continue;
            return true;
        }
        return false;
    }

    public void mergeOffsets(Match other) {
        for (int i = 0; i < other.currentOffset; ++i) {
            if (this.hasMatchAt(other.offsets[i])) continue;
            this.addOffset(other.offsets[i], other.lengths[i]);
        }
    }

    public Match getNextMatch() {
        return this.nextMatch;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Match)) {
            return false;
        }
        return ((Match)other).matchTerm.equals(this.matchTerm) && ((Match)other).nodeId.equals(this.nodeId);
    }

    public boolean matchEquals(Match other) {
        if (this == other) {
            return true;
        }
        return (this.nodeId == other.nodeId || this.nodeId.equals(other.nodeId)) && this.matchTerm.equals(other.matchTerm);
    }

    public int compareTo(Object o) {
        Match other = (Match)o;
        return this.matchTerm.compareTo(other.matchTerm);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.matchTerm);
        for (int i = 0; i < this.currentOffset; ++i) {
            buf.append(" [");
            buf.append(this.offsets[i]).append(':').append(this.lengths[i]);
            buf.append("]");
        }
        if (this.nextMatch != null) {
            buf.append(' ').append(this.nextMatch.toString());
        }
        return buf.toString();
    }

    public static final class Offset
    implements Comparable {
        private int offset;
        private int length;

        public Offset(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getLength() {
            return this.length;
        }

        public int compareTo(Object other) {
            int otherOffset = ((Offset)other).offset;
            return this.offset == otherOffset ? 0 : (this.offset < otherOffset ? -1 : 1);
        }
    }
}

