/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.DocumentImpl;
import org.exist.dom.LockToken;
import org.exist.http.webdav.WebDAVUtil;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Lock
extends AbstractWebDAVMethod {
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();

    public Lock(BrokerPool pool) {
        super(pool);
        this.docFactory.setNamespaceAware(true);
    }

    private LockToken getDefaultToken(User user) {
        LockToken lockToken = new LockToken();
        lockToken.setOwner(user.getName());
        lockToken.setType((byte)1);
        lockToken.setTimeOut(-1L);
        lockToken.setScope((byte)1);
        lockToken.setDepth((byte)0);
        return lockToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNullResource(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) {
        LOG.debug((Object)("Create NullResource for '" + path + "'."));
        DBBroker broker = null;
        Txn txn = null;
        TransactionManager txManager = null;
        try {
            broker = this.pool.get(user);
            DocumentImpl resource = null;
            LockToken lockToken = this.getDefaultToken(user);
            lockToken.createOpaqueLockToken();
            String contentType = request.getContentType();
            txManager = this.pool.getTransactionManager();
            txn = txManager.beginTransaction();
            XmldbURI collName = path.removeLastSegment();
            XmldbURI docName = path.lastSegment();
            MimeType mime = MimeTable.getInstance().getContentTypeFor(path);
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
            }
            LOG.debug((Object)("storing document '" + path + "' in collection '" + collName));
            Collection collection = null;
            try {
                collection = broker.openCollection(collName, 0);
                if (mime.isXMLType()) {
                    LOG.debug((Object)"Storing NULL xml resource");
                    String txt = "<!-- place holder for null byte sized nullresource XML document --><nullresource/>";
                    IndexInfo info = collection.validateXMLResource(txn, broker, docName, txt);
                    resource = info.getDocument();
                    info.getDocument().getMetadata().setMimeType(contentType);
                    collection.store(txn, broker, info, txt, false);
                } else {
                    LOG.debug((Object)"Storing NULL byte binary resource.");
                    resource = collection.addBinaryResource(txn, broker, docName, new byte[0], contentType);
                }
            }
            finally {
                collection.release(0);
            }
            resource.setUserLock(user);
            lockToken.setResourceType((byte)1);
            resource.getMetadata().setLockToken(lockToken);
            txManager.commit(txn);
            try {
                this.lockResource(request, response, lockToken, 201);
            }
            catch (ServletException ex) {
                LOG.error((Object)ex);
            }
            catch (IOException ex) {
                LOG.error((Object)ex);
            }
            LOG.debug((Object)"NullResourceLock done.");
        }
        catch (PermissionDeniedException ex) {
            LOG.error((Object)ex);
            txManager.abort(txn);
            try {
                response.sendError(401, ex.getMessage());
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            txManager.abort(txn);
            try {
                response.sendError(500, ex.getMessage());
            }
            catch (IOException e) {
                LOG.error((Object)e);
            }
        }
        finally {
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        boolean isNullResource = false;
        try {
            broker = this.pool.get(user);
            try {
                resource = broker.getXMLResource(path, 0);
            }
            catch (PermissionDeniedException ex) {
                LOG.error((Object)ex);
                response.sendError(401, ex.getMessage());
                if (isNullResource) {
                    if (resource != null) {
                        resource.getUpdateLock().release(0);
                    }
                    if (collection != null) {
                        collection.release(0);
                    }
                }
                if (this.pool == null) return;
                this.pool.release(broker);
                return;
            }
            if (resource == null) {
                LOG.info((Object)"resource==null, document not found.");
                collection = broker.openCollection(path, 0);
                if (collection == null) {
                    LOG.info((Object)"collection==null, path does not point to collection");
                    LOG.debug((Object)"Create document as NullResource");
                    this.createNullResource(user, request, response, path);
                    isNullResource = true;
                    return;
                }
                String txt = "Locking on collections not supported yet.";
                LOG.debug((Object)txt);
                response.sendError(501, txt);
                return;
            }
            LOG.debug((Object)"Aquire lock for existing document");
            LockToken lockToken = this.getDefaultToken(user);
            LOG.debug((Object)("Received lock request [" + lockToken.getScope() + "] " + "for owner " + lockToken.getOwner()));
            User lock = resource.getUserLock();
            if (lock != null && !lock.getName().equals(user.getName())) {
                LOG.debug((Object)"Resource is locked.");
                response.sendError(423, "Resource is locked by user " + user.getName() + ".");
                return;
            }
            if (lockToken.getScope() == 2) {
                LOG.debug((Object)"Shared locks are not implemented.");
                response.sendError(501, "Shared locks are not implemented.");
                return;
            }
            lockToken.createOpaqueLockToken();
            resource.getMetadata().setLockToken(lockToken);
            resource.setUserLock(user);
            TransactionManager transact = this.pool.getTransactionManager();
            Txn transaction = transact.beginTransaction();
            broker.storeXMLResource(transaction, resource);
            resource.getUpdateLock().release(0);
            transact.commit(transaction);
            LOG.debug((Object)("Sucessfully locked '" + path + "'."));
            this.lockResource(request, response, lockToken, 200);
            return;
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (isNullResource) {
                if (resource != null) {
                    resource.getUpdateLock().release(0);
                }
                if (collection != null) {
                    collection.release(0);
                }
            }
            if (this.pool != null) {
                this.pool.release(broker);
            }
        }
    }

    private LockToken getLockParameters(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DocumentBuilder docBuilder;
        LockToken token = new LockToken();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            LOG.error((Object)e1);
            throw new ServletException("Failed to create XML parser: ", (Throwable)e1);
        }
        Document doc = WebDAVUtil.parseRequestContent(request, response, docBuilder);
        Element lockinfo = doc.getDocumentElement();
        if (!lockinfo.getLocalName().equals("lockinfo") || !lockinfo.getNamespaceURI().equals("DAV:")) {
            LOG.debug((Object)("Unexpected element found: " + lockinfo.getNodeName()));
            response.sendError(400, "Unexpected element found: " + lockinfo.getNodeName());
            return null;
        }
        for (Node node = lockinfo.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("DAV:")) continue;
            if ("lockscope".equals(node.getLocalName())) {
                Node scopeNode = WebDAVUtil.firstElementNode(node);
                if ("exclusive".equals(scopeNode.getLocalName())) {
                    token.setScope((byte)1);
                } else if ("shared".equals(scopeNode.getLocalName())) {
                    token.setScope((byte)2);
                }
            }
            if ("locktype".equals(node.getLocalName())) {
                Node typeNode = WebDAVUtil.firstElementNode(node);
                if (!"write".equals(typeNode.getLocalName())) {
                    response.sendError(400, "Unexpected element found: " + typeNode.getNodeName());
                    return null;
                }
                token.setType((byte)1);
            }
            if (!"owner".equals(node.getLocalName())) continue;
            Node href = WebDAVUtil.firstElementNode(node);
            String owner = WebDAVUtil.getElementContent(href);
            token.setOwner(owner);
        }
        return token;
    }

    private void lockResource(HttpServletRequest request, HttpServletResponse response, LockToken lockToken, int status) throws ServletException, IOException {
        response.setStatus(status);
        response.addHeader("Lock-Token", "opaquelocktoken:" + lockToken.getOpaqueLockToken());
        response.setContentType(MimeType.XML_CONTENT_TYPE.getName());
        ServletOutputStream sos = response.getOutputStream();
        sos.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        sos.println("<D:prop xmlns:D=\"DAV:\">");
        sos.println("<D:lockdiscovery>");
        sos.println("<D:activelock>");
        sos.println("<D:locktype>");
        switch (lockToken.getType()) {
            case 1: {
                sos.println("<D:write/>");
                break;
            }
            default: {
                sos.println("<D:write/>");
            }
        }
        sos.println("</D:locktype>");
        sos.println("<D:lockscope>");
        switch (lockToken.getScope()) {
            case 1: {
                sos.println("<D:exclusive/>");
                break;
            }
            case 2: {
                sos.println("<D:shared/>");
                break;
            }
            default: {
                sos.println("<D:exclusive/>");
            }
        }
        sos.println("</D:lockscope>");
        switch (lockToken.getDepth()) {
            case 2: {
                sos.println("<D:depth>Infinity</D:depth>");
                break;
            }
            case 0: {
                sos.println("<D:depth>0</D:depth>");
                break;
            }
            case 1: {
                sos.println("<D:depth>1</D:depth>");
                break;
            }
            case 4: {
                sos.println("<D:depth>not set</D:depth>");
                break;
            }
            default: {
                sos.println("<D:depth>null</D:depth>");
            }
        }
        sos.println("<D:owner>");
        sos.println("<D:href>" + lockToken.getOwner() + "</D:href>");
        sos.println("</D:owner>");
        if (lockToken.getTimeOut() == -1L) {
            sos.println("<D:timeout>Infinite</D:timeout>");
        } else {
            sos.println("<D:timeout>Second-" + lockToken.getTimeOut() + "</D:timeout>");
        }
        sos.println("<D:locktoken>");
        sos.println("<D:href>opaquelocktoken:" + lockToken.getOpaqueLockToken() + "</D:href>");
        sos.println("</D:locktoken>");
        sos.println("</D:activelock>");
        sos.println("</D:lockdiscovery>");
        sos.println("</D:prop>");
        sos.flush();
    }
}

