/*
 * Decompiled with CFR 0.152.
 */
package org.exist.numbering;

import java.io.IOException;
import org.exist.numbering.DLN;
import org.exist.numbering.NodeId;
import org.exist.numbering.NodeIdFactory;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public class DLNFactory
implements NodeIdFactory {
    public NodeId createInstance() {
        return new DLN();
    }

    public NodeId createInstance(int id) {
        return new DLN(id);
    }

    public NodeId createFromStream(VariableByteInput is) throws IOException {
        short bitCnt = is.readShort();
        return bitCnt == 0 ? DLN.END_OF_DOCUMENT : new DLN(bitCnt, is);
    }

    public NodeId createFromStream(NodeId previous, VariableByteInput is) throws IOException {
        byte prefix = is.readByte();
        if (prefix == 0) {
            return this.createFromStream(is);
        }
        short bitCnt = is.readShort();
        return bitCnt == 0 ? DLN.END_OF_DOCUMENT : new DLN(prefix, (DLN)previous, bitCnt, is);
    }

    public NodeId createFromData(int sizeHint, byte[] data, int startOffset) {
        return new DLN(sizeHint, data, startOffset);
    }

    public NodeId createFromString(String string) {
        return new DLN(string);
    }

    public NodeId documentNodeId() {
        return DLN.DOCUMENT_NODE;
    }

    public int lengthInBytes(int units, byte[] data, int startOffset) {
        return DLN.getLengthInBytes(units, data, startOffset);
    }

    public void writeEndOfDocument(VariableByteOutputStream os) {
        os.writeByte((byte)0);
        os.writeShort(0);
    }
}

