/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;
import org.exist.security.LDAPSecurityManager;
import org.exist.security.SecurityManager;

public class LDAPbindSecurityManager
extends LDAPSecurityManager
implements SecurityManager {
    private static final Logger LOG = Logger.getLogger((Class)SecurityManager.class);

    public boolean bind(String user, String passwd) {
        Hashtable env = this.getDirectoryEnvironment();
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.principal", "uid=" + user + "," + this.userBase);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            LOG.info(ctx.lookup("uid=" + user + "," + this.userBase));
            ctx.close();
        }
        catch (NamingException e) {
            LOG.warn((Object)("Invalid Credentials for user: uid=" + user + "," + this.userBase), (Throwable)e);
            return false;
        }
        LOG.warn((Object)("User " + user + ", bind successful."));
        return true;
    }
}

