/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.security.LDAPbindSecurityManager;
import org.exist.security.MessageDigester;
import org.exist.security.SecurityManager;
import org.exist.storage.BrokerPool;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class User {
    private static final Logger LOG = Logger.getLogger((Class)User.class);
    public static final User DEFAULT = new User("guest", null, "guest");
    private static final String GROUP = "group";
    private static final String NAME = "name";
    private static final String PASS = "password";
    private static final String DIGEST_PASS = "digest-password";
    private static final String USER_ID = "uid";
    private static final String HOME = "home";
    private static String realm = "exist";
    public static final int PLAIN_ENCODING = 0;
    public static final int SIMPLE_MD5_ENCODING = 1;
    public static final int MD5_ENCODING = 2;
    public static int PASSWORD_ENCODING;
    public static boolean CHECK_PASSWORDS;
    private String[] groups = null;
    private String password = null;
    private String digestPassword = null;
    private String user;
    private int uid = -1;
    private XmldbURI home = null;
    private boolean hasDbaRole = false;

    public static void enablePasswordChecks(boolean check) {
        CHECK_PASSWORDS = check;
    }

    public static void setPasswordEncoding(String encoding) {
        if (encoding != null) {
            LOG.equals("Setting password encoding to " + encoding);
            PASSWORD_ENCODING = encoding.equalsIgnoreCase("plain") ? 0 : (encoding.equalsIgnoreCase("md5") ? 2 : 1);
        }
    }

    public static void setPasswordRealm(String value) {
        realm = value;
    }

    public User(String user, String password) {
        this.user = user;
        this.setPassword(password);
    }

    public User(String user) {
        this.user = user;
    }

    public User(String user, String password, String primaryGroup) {
        this(user, password);
        this.addGroup(primaryGroup);
    }

    public User(int majorVersion, int minorVersion, Element node) throws DatabaseConfigurationException {
        Attr attr;
        this.user = node.getAttribute(NAME);
        if (this.user == null || this.user.length() == 0) {
            throw new DatabaseConfigurationException("user needs a name");
        }
        if (majorVersion == 0) {
            attr = node.getAttributeNode(PASS);
            this.digestPassword = attr == null ? null : attr.getValue();
            this.password = null;
        } else {
            attr = node.getAttributeNode(PASS);
            String string = this.password = attr == null ? null : attr.getValue();
            if (this.password != null && this.password.length() > 0) {
                if (this.password.startsWith("{MD5}")) {
                    this.password = this.password.substring(5);
                }
                if (this.password.charAt(0) == '{') {
                    throw new DatabaseConfigurationException("Unrecognized password encoding " + this.password + " for user " + this.user);
                }
            }
            this.digestPassword = (attr = node.getAttributeNode(DIGEST_PASS)) == null ? null : attr.getValue();
        }
        Attr userId = node.getAttributeNode(USER_ID);
        if (userId == null) {
            throw new DatabaseConfigurationException("attribute id missing");
        }
        try {
            this.uid = Integer.parseInt(userId.getValue());
        }
        catch (NumberFormatException e) {
            throw new DatabaseConfigurationException("illegal user id: " + userId + " for user " + this.user);
        }
        Attr homeAttr = node.getAttributeNode(HOME);
        this.home = homeAttr == null ? null : XmldbURI.create(homeAttr.getValue());
        NodeList gl = node.getChildNodes();
        for (int i = 0; i < gl.getLength(); ++i) {
            Node group = gl.item(i);
            if (group.getNodeType() != 1 || !group.getLocalName().equals(GROUP)) continue;
            this.addGroup(group.getFirstChild().getNodeValue());
        }
    }

    public final void addGroup(String group) {
        if (this.groups == null) {
            this.groups = new String[1];
            this.groups[0] = group;
        } else {
            int len = this.groups.length;
            String[] ngroups = new String[len + 1];
            System.arraycopy(this.groups, 0, ngroups, 0, len);
            ngroups[len] = group;
            this.groups = ngroups;
        }
        if ("dba".equals(group)) {
            this.hasDbaRole = true;
        }
    }

    public final void remGroup(String group) {
        if (this.groups == null) {
            this.groups = new String[1];
            this.groups[0] = "guest";
        } else {
            int len = this.groups.length;
            String[] rgroup = null;
            if (len > 1) {
                rgroup = new String[len - 1];
            } else {
                rgroup = new String[1];
                len = 1;
            }
            boolean found = false;
            for (int i = 0; i < len; ++i) {
                if (!this.groups[i].equals(group)) {
                    if (found) {
                        rgroup[i - 1] = this.groups[i];
                        continue;
                    }
                    rgroup[i] = this.groups[i];
                    continue;
                }
                found = true;
            }
            if (found && len == 1) {
                rgroup[0] = "guest";
            }
            this.groups = rgroup;
        }
        if ("dba".equals(group)) {
            this.hasDbaRole = false;
        }
    }

    public final void setGroups(String[] groups) {
        this.groups = groups;
        for (int i = 0; i < groups.length; ++i) {
            if (!"dba".equals(groups[i])) continue;
            this.hasDbaRole = true;
        }
    }

    public final String[] getGroups() {
        return this.groups == null ? new String[]{} : this.groups;
    }

    public final boolean hasDbaRole() {
        return this.hasDbaRole;
    }

    public final String getName() {
        return this.user;
    }

    public final int getUID() {
        return this.uid;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getDigestPassword() {
        return this.digestPassword;
    }

    public final String getPrimaryGroup() {
        if (this.groups == null || this.groups.length == 0) {
            return null;
        }
        return this.groups[0];
    }

    public final boolean hasGroup(String group) {
        if (this.groups == null) {
            return false;
        }
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].equals(group)) continue;
            return true;
        }
        return false;
    }

    public final void setPassword(String passwd) {
        if (passwd == null) {
            this.password = null;
            this.digestPassword = null;
        } else {
            this.password = MessageDigester.md5(passwd, true);
            this.digestPassword = this.digest(passwd);
        }
    }

    public final void setPasswordDigest(String passwd) {
        this.digestPassword = passwd == null ? null : passwd;
    }

    public final void setEncodedPassword(String passwd) {
        this.password = passwd == null ? null : passwd;
    }

    public final String digest(String passwd) {
        switch (PASSWORD_ENCODING) {
            case 0: {
                return passwd;
            }
            case 2: {
                return MessageDigester.md5(this.user + ":" + realm + ":" + passwd, false);
            }
        }
        return MessageDigester.md5(passwd, true);
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<user name=\"");
        buf.append(this.user);
        buf.append("\" ");
        buf.append("uid=\"");
        buf.append(Integer.toString(this.uid));
        buf.append("\"");
        if (this.password != null) {
            buf.append(" password=\"{MD5}");
            buf.append(this.password);
            buf.append('\"');
        }
        if (this.digestPassword != null) {
            buf.append(" digest-password=\"");
            buf.append(this.digestPassword);
            buf.append('\"');
        }
        if (this.home != null) {
            buf.append(" home=\"");
            buf.append(this.home);
            buf.append("\">");
        } else {
            buf.append(">");
        }
        if (this.groups != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                buf.append("<group>");
                buf.append(this.groups[i]);
                buf.append("</group>");
            }
        }
        buf.append("</user>");
        return buf.toString();
    }

    public final boolean validate(String passwd) {
        try {
            SecurityManager sm = BrokerPool.getInstance().getSecurityManager();
            return this.validate(passwd, sm);
        }
        catch (EXistException e) {
            LOG.warn((Object)"Failed to get security manager in validate: ", (Throwable)e);
            return false;
        }
    }

    public final boolean validate(String passwd, SecurityManager sm) {
        if (!CHECK_PASSWORDS) {
            return true;
        }
        if (this.password == null && this.digestPassword == null) {
            return true;
        }
        if (passwd == null) {
            return false;
        }
        if (sm != null && sm instanceof LDAPbindSecurityManager) {
            return ((LDAPbindSecurityManager)sm).bind(this.user, passwd);
        }
        if (this.password != null && MessageDigester.md5(passwd, true).equals(this.password)) {
            return true;
        }
        return this.digestPassword != null && this.digest(passwd).equals(this.digestPassword);
    }

    public final boolean validateDigest(String passwd) {
        if (this.digestPassword == null) {
            return true;
        }
        if (passwd == null) {
            return false;
        }
        return this.digest(passwd).equals(this.digestPassword);
    }

    public void setUID(int uid) {
        this.uid = uid;
    }

    public void setHome(XmldbURI homeCollection) {
        this.home = homeCollection;
    }

    public XmldbURI getHome() {
        return this.home;
    }

    public boolean equals(Object obj) {
        User other = (User)obj;
        if (other != null) {
            return this.uid == other.uid;
        }
        return false;
    }

    static {
        CHECK_PASSWORDS = true;
        Properties props = new Properties();
        try {
            props.load(User.class.getClassLoader().getResourceAsStream("org/exist/security/security.properties"));
        }
        catch (IOException e) {
            // empty catch block
        }
        String option = props.getProperty("passwords.encoding", "md5");
        User.setPasswordEncoding(option);
        option = props.getProperty("passwords.check", "yes");
        CHECK_PASSWORDS = option.equalsIgnoreCase("yes") || option.equalsIgnoreCase("true");
    }
}

