/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.ResourceFinder;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.ExistPolicyModule;
import org.exist.security.xacml.RequestHelper;
import org.exist.security.xacml.UserAttributeModule;
import org.exist.security.xacml.XACMLUtil;
import org.exist.storage.BrokerPool;

public class ExistPDP {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger((Class)ExistPDP.class);
    private PDPConfig pdpConfig;
    private XACMLUtil util;
    private PDP pdp;
    private BrokerPool pool;
    private RequestHelper helper = new RequestHelper();

    private ExistPDP() {
    }

    public ExistPDP(BrokerPool pool) {
        if (pool == null) {
            throw new NullPointerException("BrokerPool cannot be null");
        }
        this.pool = pool;
        this.util = new XACMLUtil(this);
        this.pdpConfig = new PDPConfig(this.createAttributeFinder(), this.createPolicyFinder(), this.createResourceFinder());
        this.pdp = new PDP(this.pdpConfig);
    }

    public void initializePolicyCollection() {
        this.util.initializePolicyCollection();
    }

    public PDPConfig getPDPConfig() {
        return this.pdpConfig;
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public XACMLUtil getUtil() {
        return this.util;
    }

    public void close() {
        this.util.close();
    }

    public void evaluate(RequestCtx request) throws PermissionDeniedException {
        if (request == null) {
            throw new PermissionDeniedException("Request cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            request.encode((OutputStream)out, new Indenter(4));
            LOG.debug((Object)"Processing request:");
            LOG.debug((Object)out.toString());
        }
        ResponseCtx response = this.pdp.evaluate(request);
        if (LOG.isDebugEnabled()) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            response.encode((OutputStream)out, new Indenter(4));
            LOG.debug((Object)"PDP response to request:");
            LOG.debug((Object)out.toString());
        }
        this.handleResponse(response);
    }

    public void handleResponse(ResponseCtx response) throws PermissionDeniedException {
        if (response == null) {
            throw new PermissionDeniedException("The response was null");
        }
        Set results = response.getResults();
        if (results == null || results.size() == 0) {
            throw new PermissionDeniedException("The response was empty");
        }
        Iterator it = results.iterator();
        while (it.hasNext()) {
            this.handleResult((Result)it.next());
        }
    }

    public void handleResult(Result result) throws PermissionDeniedException {
        if (result == null) {
            throw new PermissionDeniedException("A result of a request's response was null");
        }
        Set obligations = result.getObligations();
        if (obligations != null && obligations.size() > 0) {
            throw new PermissionDeniedException("The XACML response had obligations that could not be fulfilled.");
        }
        int decision = result.getDecision();
        if (decision == 0) {
            return;
        }
        throw new PermissionDeniedException("The response did not permit the request.  The decision was: " + ExistPDP.getDecisionString(decision, result.getStatus()));
    }

    private static String getDecisionString(int decision, Status status) {
        switch (decision) {
            case 0: {
                return "permit the request";
            }
            case 1: {
                return "deny the request";
            }
            case 2: {
                String error;
                String string = error = status == null ? null : status.getMessage();
                if (error == null) {
                    error = "";
                } else if (error.length() > 0) {
                    error = ": " + error;
                }
                return "indeterminate (there was an error)" + error;
            }
            case 3: {
                return "the request was not applicable to the policy";
            }
        }
        return ": of an unknown type";
    }

    public PDP getPDP() {
        return this.pdp;
    }

    public RequestHelper getRequestHelper() {
        return this.helper;
    }

    private ResourceFinder createResourceFinder() {
        return null;
    }

    private AttributeFinder createAttributeFinder() {
        ArrayList<UserAttributeModule> modules = new ArrayList<UserAttributeModule>(2);
        modules.add(new UserAttributeModule(this));
        modules.add((UserAttributeModule)new CurrentEnvModule());
        AttributeFinder attributeFinder = new AttributeFinder();
        attributeFinder.setModules(modules);
        return attributeFinder;
    }

    private PolicyFinder createPolicyFinder() {
        ExistPolicyModule policyModule = new ExistPolicyModule(this);
        PolicyFinder policyFinder = new PolicyFinder();
        policyFinder.setModules(Collections.singleton(policyModule));
        return policyFinder;
    }

    static {
        Logger.getLogger("com.sun.xacml").setLevel(Level.WARNING);
    }
}

