/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.management.AgentFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;

public class ConsistencyCheckTask
implements SystemTask {
    private static final Logger LOG = Logger.getLogger((Class)ConsistencyCheckTask.class);
    private String exportDir;
    private boolean createBackup = false;
    private boolean paused = false;
    private boolean incremental = false;
    private boolean incrementalCheck = false;
    private int maxInc = -1;

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.exportDir = properties.getProperty("output", "export");
        File dir = new File(this.exportDir);
        if (!dir.isAbsolute()) {
            dir = new File((String)config.getProperty("db-connection.data-dir"), this.exportDir);
        }
        dir.mkdirs();
        this.exportDir = dir.getAbsolutePath();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using output directory " + this.exportDir));
        }
        String backup = properties.getProperty("backup", "no");
        this.createBackup = backup.equalsIgnoreCase("YES");
        String inc = properties.getProperty("incremental", "yes");
        this.incremental = inc.equalsIgnoreCase("YES");
        String incCheck = properties.getProperty("incremental-check", "no");
        this.incrementalCheck = incCheck.equalsIgnoreCase("YES");
        String max = properties.getProperty("max", "-1");
        try {
            this.maxInc = Integer.parseInt(max);
        }
        catch (NumberFormatException e) {
            throw new EXistException("Parameter 'max' has to be an integer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DBBroker broker) throws EXistException {
        if (this.paused) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Consistency check is paused.");
            }
            return;
        }
        long start = System.currentTimeMillis();
        PrintWriter report = null;
        try {
            boolean doBackup = this.createBackup;
            List errors = null;
            if (!this.incremental || this.incrementalCheck) {
                CheckCallback cb;
                ConsistencyCheck check;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Starting consistency check...");
                }
                if (!(errors = (check = new ConsistencyCheck(broker, false)).checkAll(cb = new CheckCallback(report = this.openLog()))).isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Errors found: " + errors.size()));
                    }
                    doBackup = true;
                    if (this.fatalErrorsFound(errors)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Fatal errors were found: pausing the consistency check task.");
                        }
                        this.paused = true;
                    }
                }
                AgentFactory.getInstance().updateErrors(broker.getBrokerPool(), errors, start);
            }
            if (doBackup) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Starting backup...");
                }
                SystemExport sysexport = new SystemExport(broker, null, false);
                File exportFile = sysexport.export(this.exportDir, this.incremental, this.maxInc, true, errors);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Created backup to file: " + exportFile.getAbsolutePath()));
                }
            }
        }
        finally {
            if (report != null) {
                report.close();
            }
        }
    }

    private boolean fatalErrorsFound(List errors) {
        for (int i = 0; i < errors.size(); ++i) {
            ErrorReport error = (ErrorReport)errors.get(i);
            switch (error.getErrcode()) {
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    private PrintWriter openLog() throws EXistException {
        try {
            File file = SystemExport.getUniqueFile("report", ".log", this.exportDir);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            return new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new EXistException("ERROR: failed to create report file in " + this.exportDir, e);
        }
        catch (FileNotFoundException e) {
            throw new EXistException("ERROR: failed to create report file in " + this.exportDir, e);
        }
    }

    private class CheckCallback
    implements ConsistencyCheck.ProgressCallback,
    SystemExport.StatusCallback {
        private PrintWriter log;
        private boolean errorFound = false;

        private CheckCallback(PrintWriter log) {
            this.log = log;
        }

        public void startDocument(String path) {
        }

        public void startDocument(String name, int current, int count) {
        }

        public void startCollection(String path) {
            if (this.errorFound) {
                this.log.write("----------------------------------------------\n");
            }
            this.errorFound = false;
            this.log.write("COLLECTION: ");
            this.log.write(path);
            this.log.write(10);
        }

        public void error(ErrorReport error) {
            this.log.write("----------------------------------------------\n");
            this.log.write(error.toString());
            this.log.write(10);
        }

        public void error(String message, Throwable exception) {
            this.log.write("----------------------------------------------\n");
            this.log.write("EXPORT ERROR: ");
            this.log.write(message);
            this.log.write(10);
            exception.printStackTrace(this.log);
        }
    }
}

