/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.DBBroker;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexSpec {
    private static final String TYPE_ATTRIB = "type";
    private static final String PATH_ATTRIB = "path";
    private static final String CREATE_ELEMENT = "create";
    private static final String QNAME_ATTRIB = "qname";
    private static final String FULLTEXT_ELEMENT = "fulltext";
    private static final Logger LOG = Logger.getLogger((Class)IndexSpec.class);
    private FulltextIndexSpec ftSpec = null;
    private GeneralRangeIndexSpec[] specs = null;
    private Map qnameSpecs = new TreeMap();
    private Map customIndexSpecs = null;

    public IndexSpec(DBBroker broker, Element index) throws DatabaseConfigurationException {
        this.read(broker, index);
    }

    public void read(DBBroker broker, Element index) throws DatabaseConfigurationException {
        Map namespaces = this.getNamespaceMap(index);
        NodeList cl = index.getChildNodes();
        for (int i = 0; i < cl.getLength(); ++i) {
            Node node = cl.item(i);
            if (node.getNodeType() != 1) continue;
            if (FULLTEXT_ELEMENT.equals(node.getLocalName())) {
                this.ftSpec = new FulltextIndexSpec(namespaces, (Element)node);
                continue;
            }
            if (CREATE_ELEMENT.equals(node.getLocalName())) {
                Element elem = (Element)node;
                String type = elem.getAttribute(TYPE_ATTRIB);
                if (elem.hasAttribute(QNAME_ATTRIB)) {
                    String qname = elem.getAttribute(QNAME_ATTRIB);
                    QNameRangeIndexSpec qnIdx = new QNameRangeIndexSpec(namespaces, qname, type);
                    this.qnameSpecs.put(qnIdx.getQName(), qnIdx);
                    continue;
                }
                if (elem.hasAttribute(PATH_ATTRIB)) {
                    String path = elem.getAttribute(PATH_ATTRIB);
                    GeneralRangeIndexSpec valueIdx = new GeneralRangeIndexSpec(namespaces, path, type);
                    this.addValueIndex(valueIdx);
                    continue;
                }
                String error_message = "Configuration error: element " + elem.getNodeName() + " must have attribute " + PATH_ATTRIB + " or " + QNAME_ATTRIB;
                throw new DatabaseConfigurationException(error_message);
            }
            LOG.info((Object)("Unable to process index configuration element :" + node.getLocalName()));
        }
        if (broker != null) {
            this.customIndexSpecs = broker.getIndexController().configure(cl, namespaces);
        }
    }

    public FulltextIndexSpec getFulltextIndexSpec() {
        return this.ftSpec;
    }

    public Object getCustomIndexSpec(String id) {
        return this.customIndexSpecs == null ? null : this.customIndexSpecs.get(id);
    }

    public GeneralRangeIndexSpec getIndexByPath(NodePath path) {
        if (this.specs != null) {
            for (int i = 0; i < this.specs.length; ++i) {
                if (!this.specs[i].matches(path)) continue;
                return this.specs[i];
            }
        }
        return null;
    }

    public QNameRangeIndexSpec getIndexByQName(QName name) {
        return (QNameRangeIndexSpec)this.qnameSpecs.get(name);
    }

    public boolean hasIndexesByPath() {
        return this.specs != null && this.specs.length > 0;
    }

    public boolean hasIndexesByQName() {
        return this.qnameSpecs.size() > 0;
    }

    public List getIndexedQNames() {
        ArrayList<QName> qnames = new ArrayList<QName>(8);
        Iterator i = this.qnameSpecs.keySet().iterator();
        while (i.hasNext()) {
            QName qname = (QName)i.next();
            qnames.add(qname);
        }
        return qnames;
    }

    private void addValueIndex(GeneralRangeIndexSpec valueIdx) {
        if (this.specs == null) {
            this.specs = new GeneralRangeIndexSpec[1];
            this.specs[0] = valueIdx;
        } else {
            GeneralRangeIndexSpec[] nspecs = new GeneralRangeIndexSpec[this.specs.length + 1];
            System.arraycopy(this.specs, 0, nspecs, 0, this.specs.length);
            nspecs[this.specs.length] = valueIdx;
            this.specs = nspecs;
        }
    }

    private Map getNamespaceMap(Element elem) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getPrefix() == null || !attr.getPrefix().equals("xmlns")) continue;
            map.put(attr.getLocalName(), attr.getValue());
        }
        return map;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.ftSpec != null) {
            result.append(this.ftSpec.toString()).append('\n');
        }
        if (this.specs != null) {
            for (int i = 0; i < this.specs.length; ++i) {
                GeneralRangeIndexSpec spec = this.specs[i];
                if (spec == null) continue;
                result.append(spec.toString()).append('\n');
            }
        }
        Iterator i = this.qnameSpecs.keySet().iterator();
        while (i.hasNext()) {
            result.append(this.qnameSpecs.get(i.next()).toString()).append('\n');
        }
        return result.toString();
    }
}

