/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Arrays;
import org.exist.dom.QName;

public abstract class RangeIndexSpec {
    public static final int NO_INDEX = 0;
    public static final int STRING = 1;
    public static final int INTEGER = 2;
    public static final int DOUBLE = 3;
    public static final int FLOAT = 4;
    public static final int BOOLEAN = 5;
    public static final int DATE_TIME = 6;
    public static final int DATE = 7;
    public static final int QNAME_INDEX = 16;
    public static final int TEXT_MIXED_CONTENT = 32;
    public static final int MIXED_CONTENT = 64;
    public static final int TEXT = 128;
    public static final int RANGE_INDEX_MASK = 15;
    public static final int HAS_VALUE_INDEX_MASK = 31;
    public static final int HAS_VALUE_OR_MIXED_INDEX_MASK = 63;
    private static final int[] xpathTypes = new int[]{11, 22, 31, 34, 33, 23, 50, 51};
    protected static final int[] indexTypes = new int[64];
    protected int type;

    public static final int indexTypeToXPath(int type) {
        return xpathTypes[type & 0xF];
    }

    public static final boolean hasFulltextIndex(int type) {
        return (type & 0x80) != 0;
    }

    public static final boolean hasMixedContent(int type) {
        return (type & 0x40) != 0;
    }

    public static final int xpathTypeToIndex(int type) {
        return indexTypes[type];
    }

    public static final boolean hasRangeIndex(int type) {
        return (type & 0xF) > 0 && !RangeIndexSpec.hasQNameIndex(type);
    }

    public static final boolean hasQNameIndex(int type) {
        return (type & 0x10) != 0;
    }

    public static final boolean hasQNameOrValueIndex(int type) {
        return (type & 0x3F) > 0;
    }

    public static final boolean hasMixedTextIndex(int type) {
        return (type & 0x20) > 0;
    }

    protected RangeIndexSpec() {
    }

    public int getType() {
        return this.type;
    }

    public int getIndexType() {
        return indexTypes[this.type];
    }

    public QName getQName() {
        return null;
    }

    static {
        Arrays.fill(indexTypes, 0);
        RangeIndexSpec.indexTypes[22] = 1;
        RangeIndexSpec.indexTypes[31] = 2;
        RangeIndexSpec.indexTypes[34] = 3;
        RangeIndexSpec.indexTypes[33] = 4;
        RangeIndexSpec.indexTypes[23] = 5;
        RangeIndexSpec.indexTypes[50] = 6;
        RangeIndexSpec.indexTypes[51] = 7;
    }
}

