/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.storage.Indexable;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class ValueIndexFactory {
    private static Logger LOG = Logger.getLogger((String)ValueIndexFactory.class.getName());
    public static int OFFSET_COLLECTION_ID = 0;
    public static int OFFSET_TYPE = OFFSET_COLLECTION_ID + Collection.LENGTH_COLLECTION_ID;
    public static int LENGTH_VALUE_TYPE = 1;
    public static int OFFSET_VALUE = OFFSET_TYPE + LENGTH_VALUE_TYPE;

    public static final Indexable deserialize(byte[] data, int start, int len) throws EXistException {
        byte type = data[start];
        if (Type.subTypeOf(type, 22)) {
            String s;
            try {
                s = new String(data, start + LENGTH_VALUE_TYPE, len - LENGTH_VALUE_TYPE, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)e);
                throw new EXistException(e);
            }
            return new StringValue(s);
        }
        if (Type.subTypeOf(type, 50)) {
            long value = ByteConversion.byteToLong(data, start + LENGTH_VALUE_TYPE);
            GregorianCalendar utccal = new GregorianCalendar();
            utccal.setTimeInMillis(value);
            try {
                XMLGregorianCalendar xmlutccal = DatatypeFactory.newInstance().newXMLGregorianCalendar(utccal);
                return new DateTimeValue(xmlutccal);
            }
            catch (DatatypeConfigurationException dtce) {
                throw new EXistException("Could not deserialize xs:dateTime data type for range index key: " + Type.getTypeName(type) + " - " + dtce.getMessage());
            }
        }
        if (Type.subTypeOf(type, 51)) {
            long value = ByteConversion.byteToLong(data, start + LENGTH_VALUE_TYPE);
            GregorianCalendar utccal = new GregorianCalendar();
            utccal.setTimeInMillis(value);
            try {
                XMLGregorianCalendar xmlutccal = DatatypeFactory.newInstance().newXMLGregorianCalendar(utccal);
                return new DateValue(xmlutccal);
            }
            catch (DatatypeConfigurationException dtce) {
                throw new EXistException("Could not deserialize xs:date data type for range index key: " + Type.getTypeName(type) + " - " + dtce.getMessage());
            }
            catch (XPathException xpe) {
                throw new EXistException("Could not deserialize xs:date data type for range index key: " + Type.getTypeName(type) + " - " + xpe.getMessage());
            }
        }
        if (Type.subTypeOf(type, 31)) {
            return new IntegerValue(ByteConversion.byteToLong(data, start + LENGTH_VALUE_TYPE) ^ Long.MIN_VALUE);
        }
        if (type == 34) {
            long bits = ByteConversion.byteToLong(data, start + LENGTH_VALUE_TYPE) ^ Long.MIN_VALUE;
            double d = Double.longBitsToDouble(bits);
            return new DoubleValue(d);
        }
        if (type == 33) {
            int bits = ByteConversion.byteToInt(data, start + LENGTH_VALUE_TYPE) ^ Integer.MIN_VALUE;
            float f = Float.intBitsToFloat(bits);
            return new FloatValue(f);
        }
        if (type == 23) {
            return new BooleanValue(data[start + LENGTH_VALUE_TYPE] == 1);
        }
        throw new EXistException("Unknown data type for deserialization: " + Type.getTypeName(type));
    }

    public static final byte[] serialize(Indexable value, int offset) throws EXistException {
        return ValueIndexFactory.serialize(value, offset, true);
    }

    public static final byte[] serialize(Indexable value, int offset, boolean caseSensitive) throws EXistException {
        if (Type.subTypeOf(value.getType(), 22)) {
            String val = caseSensitive ? ((StringValue)value).getStringValue() : ((StringValue)value).getStringValue().toLowerCase();
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + UTF8.encoded(val)];
            data[offset] = (byte)value.getType();
            UTF8.encode(val, data, offset + LENGTH_VALUE_TYPE);
            return data;
        }
        if (Type.subTypeOf(value.getType(), 50)) {
            GregorianCalendar utccal = ((AbstractDateTimeValue)value).calendar.normalize().toGregorianCalendar();
            long millis = utccal.getTimeInMillis();
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 8];
            data[offset] = 50;
            ByteConversion.longToByte(millis, data, offset + 1);
            return data;
        }
        if (Type.subTypeOf(value.getType(), 51)) {
            GregorianCalendar utccal = ((AbstractDateTimeValue)value).calendar.normalize().toGregorianCalendar();
            long millis = utccal.getTimeInMillis();
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 8];
            data[offset] = 51;
            ByteConversion.longToByte(millis, data, offset + 1);
            return data;
        }
        if (Type.subTypeOf(value.getType(), 31)) {
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 8];
            data[offset] = 31;
            long l = ((IntegerValue)value).getValue() - Long.MIN_VALUE;
            ByteConversion.longToByte(l, data, offset + LENGTH_VALUE_TYPE);
            return data;
        }
        if (value.getType() == 34) {
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 8];
            data[offset] = 34;
            long bits = Double.doubleToLongBits(((DoubleValue)value).getValue()) ^ Long.MIN_VALUE;
            ByteConversion.longToByte(bits, data, offset + LENGTH_VALUE_TYPE);
            return data;
        }
        if (value.getType() == 33) {
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 4];
            data[offset] = 33;
            int bits = Float.floatToIntBits(((FloatValue)value).getValue()) ^ Integer.MIN_VALUE;
            ByteConversion.intToByte(bits, data, offset + LENGTH_VALUE_TYPE);
            return data;
        }
        if (value.getType() == 23) {
            byte[] data = new byte[offset + LENGTH_VALUE_TYPE + 1];
            data[offset] = 23;
            data[offset + ValueIndexFactory.LENGTH_VALUE_TYPE] = (byte)(((BooleanValue)value).getValue() ? 1 : 0);
            return data;
        }
        throw new EXistException("Unknown data type for serialization: " + Type.getTypeName(value.getType()));
    }
}

