/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class SetPageLinkLoggable
extends BTAbstractLoggable {
    protected long nextPage;
    protected long pageNum;

    public SetPageLinkLoggable(Txn transaction, byte fileId, long pageNum, long nextPage) {
        super((byte)38, fileId, transaction);
        this.pageNum = pageNum;
        this.nextPage = nextPage;
    }

    public SetPageLinkLoggable(DBBroker broker, long transactionId) {
        super((byte)38, broker, transactionId);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getLong();
        this.nextPage = in.getLong();
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putLong(this.pageNum);
        out.putLong(this.nextPage);
    }

    public int getLogSize() {
        return super.getLogSize() + 16;
    }

    public void redo() throws LogException {
        this.getStorage().redoSetPageLink(this);
    }

    public String dump() {
        return super.dump() + " - set next page link for page: " + this.pageNum + ": " + this.nextPage;
    }
}

