/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.dom.AttrImpl;
import org.exist.dom.CDATASectionImpl;
import org.exist.dom.CommentImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentTypeImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.ProcessingInstructionImpl;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.util.Configuration;
import org.exist.util.serializer.AttrList;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NativeSerializer
extends Serializer {
    private static final QName TEXT_ELEMENT = new QName("text", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ATTRIB_ELEMENT = new QName("attribute", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName SOURCE_ATTRIB = new QName("source", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final QName ID_ATTRIB = new QName("id", "http://exist.sourceforge.net/NS/exist", "exist");

    public NativeSerializer(DBBroker broker, Configuration config) {
        super(broker, config);
    }

    protected void serializeToReceiver(NodeProxy p, boolean generateDocEvent, boolean checkAttributes) throws SAXException {
        if (Type.subTypeOf(p.getType(), 6) || p.getNodeId() == NodeId.DOCUMENT_NODE) {
            this.serializeToReceiver(p.getDocument(), generateDocEvent);
            return;
        }
        this.setDocument(p.getDocument());
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        Iterator domIter = this.broker.getNodeIterator(new StoredNode(p));
        this.serializeToReceiver(null, domIter, p.getDocument(), checkAttributes, p.getMatches(), new TreeSet());
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
    }

    protected void serializeToReceiver(DocumentImpl doc, boolean generateDocEvent) throws SAXException {
        long start = System.currentTimeMillis();
        this.setDocument(doc);
        NodeList children = doc.getChildNodes();
        if (generateDocEvent) {
            this.receiver.startDocument();
        }
        if (doc.getDoctype() != null && this.getProperty("output-doctype", "no").equals("yes")) {
            StoredNode n = (StoredNode)((Object)doc.getDoctype());
            this.serializeToReceiver(n, null, (DocumentImpl)n.getOwnerDocument(), true, null, new TreeSet());
        }
        for (int i = 0; i < children.getLength(); ++i) {
            StoredNode node = (StoredNode)children.item(i);
            Iterator domIter = this.broker.getNodeIterator(node);
            domIter.next();
            NodeProxy p = new NodeProxy(node);
            this.serializeToReceiver(node, domIter, (DocumentImpl)node.getOwnerDocument(), true, p.getMatches(), new TreeSet());
        }
        DocumentImpl documentImpl = doc;
        LOG.debug((Object)("serializing document " + documentImpl.getDocId() + " (" + documentImpl.getURI() + ")" + " to SAX took " + (System.currentTimeMillis() - start)));
        if (generateDocEvent) {
            this.receiver.endDocument();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void serializeToReceiver(StoredNode node, Iterator iter, DocumentImpl doc, boolean first, Match match, Set namespaces) throws SAXException {
        if (node == null) {
            node = (StoredNode)iter.next();
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                int count;
                String ns;
                String defaultNS = null;
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    Iterator i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        if (prefix.length() == 0) {
                            defaultNS = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                            this.receiver.startPrefixMapping("", defaultNS);
                            namespaces.add(defaultNS);
                            continue;
                        }
                        String uri = ((ElementImpl)node).getNamespaceForPrefix(prefix);
                        this.receiver.startPrefixMapping(prefix, uri);
                        namespaces.add(uri);
                    }
                }
                String string = ns = defaultNS == null ? node.getNamespaceURI() : defaultNS;
                if (ns.length() > 0 && !namespaces.contains(ns)) {
                    this.receiver.startPrefixMapping(node.getPrefix(), ns);
                }
                AttrList attribs = new AttrList();
                if (first && this.showId == 1 || this.showId == 2) {
                    attribs.addAttribute(ID_ATTRIB, node.getNodeId().toString());
                }
                if (first && this.showId > 0) {
                    attribs.addAttribute(SOURCE_ATTRIB, doc.getFileURI().toString());
                }
                int children = node.getChildCount();
                StoredNode child = null;
                for (count = 0; count < children && (child = (StoredNode)iter.next()) != null && child.getNodeType() == 2; ++count) {
                    String cdata = (this.getHighlightingMode() & 2) > 0 ? this.processAttribute(((AttrImpl)child).getValue(), node.getNodeId(), match) : ((AttrImpl)child).getValue();
                    attribs.addAttribute(child.getQName(), cdata);
                    child.release();
                }
                this.receiver.setCurrentNode(node);
                this.receiver.startElement(node.getQName(), attribs);
                while (count < children) {
                    this.serializeToReceiver(child, iter, doc, false, match, namespaces);
                    if (++count >= children) break;
                    child = (StoredNode)iter.next();
                }
                this.receiver.setCurrentNode(node);
                this.receiver.endElement(node.getQName());
                if (((ElementImpl)node).declaresNamespacePrefixes()) {
                    Iterator i = ((ElementImpl)node).getPrefixes();
                    while (i.hasNext()) {
                        String prefix = (String)i.next();
                        this.receiver.endPrefixMapping(prefix);
                    }
                }
                if (ns.length() > 0 && !namespaces.contains(ns)) {
                    this.receiver.endPrefixMapping(node.getPrefix());
                }
                node.release();
                return;
            }
            case 3: {
                if (first && this.createContainerElements) {
                    AttrList tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(ID_ATTRIB, node.getNodeId().toString());
                        tattribs.addAttribute(SOURCE_ATTRIB, doc.getFileURI().toString());
                    }
                    this.receiver.startElement(TEXT_ELEMENT, tattribs);
                }
                this.receiver.setCurrentNode(node);
                this.receiver.characters(((TextImpl)node).getXMLString());
                if (first && this.createContainerElements) {
                    this.receiver.endElement(TEXT_ELEMENT);
                }
                node.release();
                return;
            }
            case 2: {
                String cdata = (this.getHighlightingMode() & 2) == 2 ? this.processAttribute(((AttrImpl)node).getValue(), node.getNodeId(), match) : ((AttrImpl)node).getValue();
                if (first) {
                    if (!this.createContainerElements) {
                        LOG.warn((Object)("Error SENR0001: attribute '" + node.getQName() + "' has no parent element. " + "While serializing document " + doc.getURI()));
                        throw new SAXException("Error SENR0001: attribute '" + node.getQName() + "' has no parent element");
                    }
                    AttrList tattribs = new AttrList();
                    if (this.showId > 0) {
                        tattribs.addAttribute(ID_ATTRIB, node.getNodeId().toString());
                        tattribs.addAttribute(SOURCE_ATTRIB, doc.getFileURI().toString());
                    }
                    tattribs.addAttribute(node.getQName(), cdata);
                    this.receiver.startElement(ATTRIB_ELEMENT, tattribs);
                    this.receiver.endElement(ATTRIB_ELEMENT);
                } else {
                    this.receiver.attribute(node.getQName(), cdata);
                }
                node.release();
                return;
            }
            case 10: {
                String systemId = ((DocumentTypeImpl)node).getSystemId();
                String publicId = ((DocumentTypeImpl)node).getPublicId();
                String name = ((DocumentTypeImpl)node).getName();
                this.receiver.documentType(name, publicId, systemId);
                return;
            }
            case 7: {
                this.receiver.processingInstruction(((ProcessingInstructionImpl)node).getTarget(), ((ProcessingInstructionImpl)node).getData());
                node.release();
                return;
            }
            case 8: {
                String comment = ((CommentImpl)node).getData();
                char[] data = new char[comment.length()];
                comment.getChars(0, data.length, data, 0);
                this.receiver.comment(data, 0, data.length);
                node.release();
                return;
            }
            case 4: {
                String str = ((CDATASectionImpl)node).getData();
                if (first) {
                    this.receiver.characters(str);
                    return;
                }
                char[] data = new char[str.length()];
                str.getChars(0, str.length(), data, 0);
                this.receiver.cdataSection(data, 0, data.length);
                return;
            }
        }
    }

    private final String processAttribute(String data, NodeId nodeId, Match match) {
        if (match == null) {
            return data;
        }
        StringBuffer expr = null;
        for (Match next = match; next != null; next = next.getNextMatch()) {
            if (!next.getNodeId().equals(nodeId)) continue;
            if (expr == null) {
                expr = new StringBuffer();
                expr.append("\\b(");
            }
            if (expr.length() > 5) {
                expr.append('|');
            }
            expr.append("");
        }
        if (expr != null) {
            expr.append(")\\b");
            Pattern pattern = Pattern.compile(expr.toString(), 66);
            Matcher matcher = pattern.matcher(data);
            return matcher.replaceAll("||$1||");
        }
        return data;
    }
}

