/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.txn;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Date;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;

public class Checkpoint
extends AbstractLoggable {
    private long timestamp = new Date().getTime();
    private long storedLsn;
    private static final DateFormat df = DateFormat.getDateTimeInstance(2, 2);

    public Checkpoint(long transactionId) {
        this(null, transactionId);
    }

    public Checkpoint(DBBroker broker, long transactionId) {
        super((byte)2, transactionId);
    }

    public void write(ByteBuffer out) {
        out.putLong(this.lsn);
        out.putLong(this.timestamp);
    }

    public void read(ByteBuffer in) {
        this.storedLsn = in.getLong();
        this.timestamp = in.getLong();
    }

    public long getStoredLsn() {
        return this.storedLsn;
    }

    public int getLogSize() {
        return 16;
    }

    public String getDateString() {
        return df.format(new Date(this.timestamp));
    }

    public String dump() {
        return super.dump() + " - checkpoint at " + df.format(new Date(this.timestamp));
    }
}

