/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

public class ByteArrayPool {
    public static final int POOL_SIZE = 32;
    public static final int MAX = 128;
    public static final ThreadLocal pools_ = new PoolThreadLocal();
    private static int slot_ = 0;

    public static byte[] getByteArray(int size) {
        byte[][] pool = (byte[][])pools_.get();
        if (size < 128) {
            int i = pool.length;
            while (i-- > 0) {
                if (pool[i] == null || pool[i].length != size) continue;
                byte[] b = pool[i];
                pool[i] = null;
                return b;
            }
        }
        return new byte[size];
    }

    public static void releaseByteArray(byte[] b) {
        int s;
        if (b == null || b.length > 128) {
            return;
        }
        byte[][] pool = (byte[][])pools_.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        if ((s = slot_++) < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class PoolThreadLocal
    extends ThreadLocal {
        private PoolThreadLocal() {
        }

        protected Object initialValue() {
            return new byte[32][];
        }
    }
}

