/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.internal.node;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.exist.storage.io.BlockingInputStream;
import org.exist.storage.io.BlockingOutputStream;
import org.exist.validation.internal.node.NodeSerializerThread;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.SequenceIterator;

public class NodeInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger((Class)NodeInputStream.class);
    private BlockingInputStream bis;
    private BlockingOutputStream bos;
    private NodeSerializerThread rt;

    public NodeInputStream(XQueryContext context, SequenceIterator siNode) {
        logger.debug((Object)"Initializing NodeInputStream");
        this.bis = new BlockingInputStream();
        this.bos = this.bis.getOutputStream();
        this.rt = new NodeSerializerThread(context, siNode, this.bos);
        this.rt.start();
        logger.debug((Object)"Initializing NodeInputStream done");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.bis.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }

    public void reset() throws IOException {
        this.bis.reset();
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public void close() throws IOException {
        this.bis.close();
    }

    public int available() throws IOException {
        return this.bis.available();
    }
}

