/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.validation.internal.DatabaseResources;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.xml.sax.InputSource;

public class SearchResourceResolver
implements XMLEntityResolver {
    private static final Logger LOG = Logger.getLogger((Class)SearchResourceResolver.class);
    private String collection = null;
    private BrokerPool brokerPool = null;

    public SearchResourceResolver(String collectionPath, BrokerPool pool) {
        LOG.debug((Object)("Specified collectionPath=" + collectionPath));
        this.collection = collectionPath;
        this.brokerPool = pool;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        LOG.debug((Object)("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri)));
        String resourcePath = null;
        DatabaseResources databaseResources = new DatabaseResources(this.brokerPool);
        User user = this.brokerPool.getSecurityManager().getUser("guest");
        if (xri.getNamespace() != null) {
            LOG.debug((Object)("Searching namespace '" + xri.getNamespace() + "' in database from " + this.collection + "..."));
            resourcePath = databaseResources.findXSD(this.collection, xri.getNamespace(), user);
        } else if (xri.getPublicId() != null) {
            LOG.debug((Object)("Searching publicId '" + xri.getPublicId() + "' in catalogs in database from " + this.collection + "..."));
            String catalogPath = databaseResources.findCatalogWithDTD(this.collection, xri.getPublicId(), user);
            LOG.info((Object)("Found publicId in catalog '" + catalogPath + "'"));
            if (catalogPath != null && catalogPath.startsWith("/")) {
                catalogPath = "xmldb:exist://" + catalogPath;
            }
            eXistXMLCatalogResolver resolver = new eXistXMLCatalogResolver();
            resolver.setCatalogList(new String[]{catalogPath});
            try {
                InputSource source = resolver.resolveEntity(xri.getPublicId(), "");
                if (source != null) {
                    resourcePath = source.getSystemId();
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)ex);
                ex.printStackTrace();
            }
        } else {
            return null;
        }
        if (resourcePath == null) {
            LOG.debug((Object)"resourcePath=null");
            return null;
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = "xmldb:exist://" + resourcePath;
        }
        LOG.debug((Object)("resourcePath='" + resourcePath + "'"));
        InputStream is = new URL(resourcePath).openStream();
        XMLInputSource xis = new XMLInputSource(xri.getPublicId(), xri.getExpandedSystemId(), xri.getBaseSystemId(), is, "UTF-8");
        LOG.debug((Object)("XMLInputSource: " + this.getXisDetails(xis)));
        return xis;
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        StringBuffer sb = new StringBuffer();
        sb.append("PublicId='").append(xrid.getPublicId()).append("' ");
        sb.append("BaseSystemId='").append(xrid.getBaseSystemId()).append("' ");
        sb.append("ExpandedSystemId='").append(xrid.getExpandedSystemId()).append("' ");
        sb.append("LiteralSystemId='").append(xrid.getLiteralSystemId()).append("' ");
        sb.append("Namespace='").append(xrid.getNamespace()).append("' ");
        return sb.toString();
    }

    private String getXisDetails(XMLInputSource xis) {
        StringBuffer sb = new StringBuffer();
        sb.append("PublicId='").append(xis.getPublicId()).append("' ");
        sb.append("SystemId='").append(xis.getSystemId()).append("' ");
        sb.append("BaseSystemId='").append(xis.getBaseSystemId()).append("' ");
        sb.append("Encoding='").append(xis.getEncoding()).append("' ");
        return sb.toString();
    }
}

