/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class eXistXMLCatalogResolver
extends XMLCatalogResolver {
    private static final Logger LOG = Logger.getLogger((Class)eXistXMLCatalogResolver.class);

    public eXistXMLCatalogResolver() {
        LOG.debug((Object)"Initializing");
    }

    public eXistXMLCatalogResolver(String[] catalogs) {
        super(catalogs);
        LOG.debug((Object)"Initializing using catalogs");
    }

    eXistXMLCatalogResolver(String[] catalogs, boolean preferPublic) {
        super(catalogs, preferPublic);
        LOG.debug((Object)("Initializing using catalogs, preferPublic=" + preferPublic));
    }

    public void setCatalogs(List catalogs) {
        if (catalogs != null && catalogs.size() > 0) {
            String[] allCatalogs = new String[catalogs.size()];
            int counter = 0;
            Iterator it = catalogs.iterator();
            while (it.hasNext()) {
                String element;
                allCatalogs[counter] = element = (String)it.next();
                ++counter;
            }
            super.setCatalogList(allCatalogs);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug((Object)("Resolving publicId='" + publicId + "', systemId='" + systemId + "'"));
        InputSource retValue = super.resolveEntity(publicId, systemId);
        if (retValue == null) {
            retValue = this.resolveEntityFallback(publicId, systemId);
        }
        LOG.debug((Object)("Resolved " + (retValue != null)));
        if (retValue != null) {
            LOG.debug((Object)("PublicId='" + retValue.getPublicId() + "' SystemId=" + retValue.getSystemId()));
        }
        return retValue;
    }

    private InputSource resolveEntityFallback(String publicId, String systemId) throws SAXException, IOException {
        LOG.debug((Object)"Resolve failed, fallback scenario");
        if (publicId != null) {
            return null;
        }
        URL url = new URL(systemId);
        if (url.getProtocol().equals("file")) {
            String path = url.getPath();
            File f = new File(path);
            if (!f.canRead()) {
                return this.resolveEntity(null, f.getName());
            }
            return new InputSource(f.getAbsolutePath());
        }
        return new InputSource(url.openStream());
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        LOG.debug((Object)("Resolving type='" + type + "', namespaceURI='" + namespaceURI + "', publicId='" + publicId + "', systemId='" + systemId + "', baseURI='" + baseURI + "'"));
        LSInput retValue = super.resolveResource(type, namespaceURI, publicId, systemId, baseURI);
        LOG.debug((Object)("Resolved " + (retValue != null)));
        if (retValue != null) {
            LOG.debug((Object)("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "' BaseURI='" + retValue.getBaseURI() + "'"));
        }
        return retValue;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        LOG.debug((Object)("Resolving name='" + name + "', publicId='" + publicId + "', baseURI='" + baseURI + "', systemId='" + systemId + "'"));
        InputSource retValue = super.resolveEntity(name, publicId, baseURI, systemId);
        LOG.debug((Object)("Resolved " + (retValue != null)));
        if (retValue != null) {
            LOG.debug((Object)("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "'"));
        }
        return retValue;
    }

    public String resolveIdentifier(XMLResourceIdentifier xri) throws IOException, XNIException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        LOG.debug((Object)("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri)));
        String retValue = super.resolveIdentifier(xri);
        LOG.debug((Object)("Resolved " + (retValue != null)));
        if (retValue != null) {
            LOG.debug((Object)("Identifier='" + retValue + "'"));
        }
        return retValue;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xri) throws XNIException, IOException {
        if (xri.getExpandedSystemId() == null && xri.getLiteralSystemId() == null && xri.getNamespace() == null && xri.getPublicId() == null) {
            return null;
        }
        LOG.debug((Object)("Resolving XMLResourceIdentifier: " + this.getXriDetails(xri)));
        XMLInputSource retValue = super.resolveEntity(xri);
        LOG.debug((Object)("Resolved " + (retValue != null)));
        if (retValue != null) {
            LOG.debug((Object)("PublicId='" + retValue.getPublicId() + "' SystemId='" + retValue.getSystemId() + "' BaseSystemId=" + retValue.getBaseSystemId()));
        }
        return retValue;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        LOG.debug((Object)("name='" + name + "' baseURI='" + baseURI + "'"));
        return super.getExternalSubset(name, baseURI);
    }

    private String getXriDetails(XMLResourceIdentifier xrid) {
        StringBuffer sb = new StringBuffer();
        sb.append("PublicId='").append(xrid.getPublicId()).append("' ");
        sb.append("BaseSystemId='").append(xrid.getBaseSystemId()).append("' ");
        sb.append("ExpandedSystemId='").append(xrid.getExpandedSystemId()).append("' ");
        sb.append("LiteralSystemId='").append(xrid.getLiteralSystemId()).append("' ");
        sb.append("Namespace='").append(xrid.getNamespace()).append("' ");
        return sb.toString();
    }
}

