/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.util.Date;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.DocumentType;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.XMLDBException;

public abstract class AbstractEXistResource
implements EXistResource {
    protected User user;
    protected BrokerPool pool;
    protected LocalCollection parent;
    protected XmldbURI docId = null;
    protected String mimeType = null;
    protected boolean isNewResource = false;

    public AbstractEXistResource(User user, BrokerPool pool, LocalCollection parent, XmldbURI docId, String mimeType) {
        this.user = user;
        this.pool = pool;
        this.parent = parent;
        this.docId = docId = docId.lastSegment();
        this.mimeType = mimeType;
    }

    public AbstractEXistResource(User user, BrokerPool pool, LocalCollection parent, String docId, String mimeType) {
        this(user, pool, parent, XmldbURI.create(docId), mimeType);
    }

    public abstract Date getCreationTime() throws XMLDBException;

    public abstract Date getLastModificationTime() throws XMLDBException;

    public abstract Permission getPermissions() throws XMLDBException;

    public void setLexicalHandler(LexicalHandler handler) {
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public String getMimeType() throws XMLDBException {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentImpl openDocument(DBBroker broker, int lockMode) throws XMLDBException {
        DocumentImpl document = null;
        Collection parentCollection = null;
        try {
            parentCollection = this.parent.getCollectionWithLock(lockMode);
            if (parentCollection == null) {
                throw new XMLDBException(201, "Collection " + this.parent.getPath() + " not found");
            }
            try {
                document = parentCollection.getDocumentWithLock(broker, this.docId, lockMode);
            }
            catch (LockException e) {
                throw new XMLDBException(4, "Failed to acquire lock on document " + this.docId);
            }
            if (document == null) {
                throw new XMLDBException(301);
            }
            DocumentImpl documentImpl = document;
            return documentImpl;
        }
        finally {
            if (parentCollection != null) {
                parentCollection.release(lockMode);
            }
        }
    }

    protected void closeDocument(DocumentImpl doc, int lockMode) throws XMLDBException {
        if (doc == null) {
            return;
        }
        doc.getUpdateLock().release(lockMode);
    }

    public DocumentType getDocType() throws XMLDBException {
        return null;
    }

    public void setDocType(DocumentType doctype) throws XMLDBException {
    }
}

