/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.RemoteXMLResource;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

public class RemoteResourceSet
implements ResourceSet {
    protected RemoteCollection collection;
    protected int handle = -1;
    protected List resources;
    protected Properties outputProperties;
    private static Logger LOG = Logger.getLogger((String)RemoteResourceSet.class.getName());

    public RemoteResourceSet(RemoteCollection col, Properties properties, Object[] resources, int handle) {
        this.handle = handle;
        this.resources = new ArrayList(resources.length);
        for (int i = 0; i < resources.length; ++i) {
            this.resources.add(resources[i]);
        }
        this.collection = col;
        this.outputProperties = properties;
    }

    public void addResource(Resource resource) {
        this.resources.add(resource);
    }

    public void clear() throws XMLDBException {
        ArrayList<Integer> params = new ArrayList<Integer>(1);
        params.add(new Integer(this.handle));
        try {
            this.collection.getClient().execute("releaseQueryResult", params);
        }
        catch (XmlRpcException e) {
            System.err.println("Failed to release query result on server: " + e.getMessage());
        }
        this.resources.clear();
    }

    public ResourceIterator getIterator() throws XMLDBException {
        return new NewResourceIterator();
    }

    public ResourceIterator getIterator(long start) throws XMLDBException {
        return new NewResourceIterator(start);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        ArrayList<Serializable> params = new ArrayList<Serializable>(2);
        params.add(new Integer(this.handle));
        params.add(this.outputProperties);
        try {
            String content;
            byte[] data = (byte[])this.collection.getClient().execute("retrieveAll", params);
            try {
                content = new String(data, this.outputProperties.getProperty("encoding", "UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                LOG.warn((Object)ue);
                content = new String(data);
            }
            RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, 0, XmldbURI.EMPTY_URI, null);
            res.setContent(content);
            res.setProperties(this.outputProperties);
            return res;
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
    }

    public Resource getResource(long pos) throws XMLDBException {
        if (pos >= (long)this.resources.size()) {
            return null;
        }
        if (this.resources.get((int)pos) instanceof Object[]) {
            XmldbURI docUri;
            Object[] v = (Object[])this.resources.get((int)pos);
            String doc = (String)v[0];
            String s_id = (String)v[1];
            try {
                docUri = XmldbURI.xmldbUriFor(doc);
            }
            catch (URISyntaxException e) {
                throw new XMLDBException(5, e.getMessage(), (Throwable)e);
            }
            RemoteCollection parent = new RemoteCollection(this.collection.getClient(), null, docUri.removeLastSegment());
            parent.properties = this.outputProperties;
            RemoteXMLResource res = new RemoteXMLResource(parent, this.handle, (int)pos, docUri, s_id);
            res.setProperties(this.outputProperties);
            return res;
        }
        if (this.resources.get((int)pos) instanceof Resource) {
            return (Resource)this.resources.get((int)pos);
        }
        RemoteXMLResource res = new RemoteXMLResource(this.collection, this.handle, (int)pos, XmldbURI.create(Long.toString(pos)), null);
        res.setContent(this.resources.get((int)pos));
        res.setProperties(this.outputProperties);
        return res;
    }

    public long getSize() throws XMLDBException {
        return this.resources == null ? 0L : (long)this.resources.size();
    }

    public void removeResource(long pos) throws XMLDBException {
        this.resources.get((int)pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    class NewResourceIterator
    implements ResourceIterator {
        long pos = 0L;

        public NewResourceIterator() {
        }

        public NewResourceIterator(long start) {
            this.pos = start;
        }

        public boolean hasMoreResources() throws XMLDBException {
            return RemoteResourceSet.this.resources == null ? false : this.pos < (long)RemoteResourceSet.this.resources.size();
        }

        public Resource nextResource() throws XMLDBException {
            return RemoteResourceSet.this.getResource(this.pos++);
        }
    }
}

