/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.RemoteCollection;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XUpdateQueryService;

public class RemoteXUpdateQueryService
implements XUpdateQueryService {
    private static final Logger LOG = Logger.getLogger((Class)RemoteXUpdateQueryService.class);
    private RemoteCollection parent;

    public RemoteXUpdateQueryService(RemoteCollection parent) {
        this.parent = parent;
    }

    public long update(String commands) throws XMLDBException {
        byte[] xupdateData;
        LOG.debug((Object)("processing xupdate:\n" + commands));
        Vector<Object> params = new Vector<Object>();
        try {
            xupdateData = commands.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            xupdateData = commands.getBytes();
        }
        params.addElement(this.parent.getPath());
        params.addElement(xupdateData);
        try {
            Integer mods = (Integer)this.parent.getClient().execute("xupdate", params);
            LOG.debug((Object)("processed " + mods + " modifications"));
            return mods.intValue();
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public long updateResource(String id, String commands) throws XMLDBException {
        byte[] xupdateData;
        LOG.debug((Object)("processing xupdate:\n" + commands));
        Vector<Object> params = new Vector<Object>();
        try {
            xupdateData = commands.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn((Object)e);
            xupdateData = commands.getBytes();
        }
        params.addElement(this.parent.getPath() + "/" + id);
        params.addElement(xupdateData);
        try {
            Integer mods = (Integer)this.parent.getClient().execute("xupdateResource", params);
            LOG.debug((Object)("processed " + mods + " modifications"));
            return mods.intValue();
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public String getName() throws XMLDBException {
        return "XUpdateQueryService";
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void setCollection(Collection col) throws XMLDBException {
        this.parent = (RemoteCollection)col;
    }

    public String getProperty(String name) throws XMLDBException {
        return null;
    }

    public void setProperty(String name, String value) throws XMLDBException {
    }
}

