/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;

public class AttributeConstructor
extends NodeConstructor {
    final String qname;
    final List contents = new ArrayList(5);
    boolean isNamespaceDecl = false;

    public AttributeConstructor(XQueryContext context, String name) {
        super(context);
        if (name.startsWith("xmlns")) {
            this.isNamespaceDecl = true;
        }
        this.qname = name;
    }

    public void addValue(String value) {
        this.contents.add(value);
    }

    public void addEnclosedExpr(Expression expr) throws XPathException {
        if (this.isNamespaceDecl) {
            throw new XPathException(this.getASTNode(), "enclosed expressions are not allowed in namespace declaration attributes");
        }
        this.contents.add(expr);
    }

    public String getQName() {
        return this.qname;
    }

    public boolean isNamespaceDeclaration() {
        return this.isNamespaceDecl;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        contextInfo.setParent(this);
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (!(next instanceof Expression)) continue;
            ((Expression)next).analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof Expression) {
                this.evalEnclosedExpr(((Expression)next).eval(contextSequence, contextItem), buf);
                continue;
            }
            buf.append(next);
        }
        StringValue result = new StringValue(buf.toString());
        return result;
    }

    private void evalEnclosedExpr(Sequence seq, StringBuffer buf) throws XPathException {
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            AtomicValue atomic = item.atomize();
            buf.append(atomic.getStringValue());
            if (!i.hasNext()) continue;
            buf.append(' ');
        }
    }

    public String getLiteralValue() {
        if (this.contents.size() == 0) {
            return "";
        }
        return (String)this.contents.get(0);
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("attribute ");
        dumper.display("{");
        dumper.display(this.qname);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof Expression) {
                ((Expression)next).dump(dumper);
                continue;
            }
            dumper.display(next);
        }
        dumper.endIndent();
        dumper.nl().display("} ");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("attribute ");
        result.append("{");
        result.append(this.qname);
        result.append("} ");
        result.append("{");
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next instanceof Expression) {
                result.append(next.toString());
                continue;
            }
            result.append(next.toString());
        }
        result.append("} ");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        Iterator i = this.contents.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof Expression)) continue;
            ((Expression)object).resetState(postOptimization);
        }
    }

    public Iterator contentIterator() {
        return this.contents.iterator();
    }
}

