/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class DocumentConstructor
extends NodeConstructor {
    private final Expression content;

    public DocumentConstructor(XQueryContext context, Expression contentExpr) {
        super(context);
        this.content = contentExpr;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
        newContextInfo.setParent(this);
        newContextInfo.addFlag(256);
        this.content.analyze(newContextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence contentSeq = this.content.eval(contextSequence, contextItem);
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        try {
            if (!contentSeq.isEmpty()) {
                StringBuffer buf = null;
                SequenceIterator i = contentSeq.iterate();
                Item next = i.nextItem();
                while (next != null) {
                    this.context.proceed(this, builder);
                    if (next.getType() == 2 || next.getType() == 500) {
                        throw new XPathException(this.getASTNode(), "Found a node of type " + Type.getTypeName(next.getType()) + " inside a document constructor");
                    }
                    if (Type.subTypeOf(next.getType(), 20)) {
                        if (buf == null) {
                            buf = new StringBuffer();
                        } else if (buf.length() > 0) {
                            buf.append(' ');
                        }
                        buf.append(next.getStringValue());
                        next = i.nextItem();
                        continue;
                    }
                    if (next.getType() == 6) {
                        if (buf != null && buf.length() > 0) {
                            receiver.characters(buf);
                            buf.setLength(0);
                        }
                        next.copyTo(this.context.getBroker(), receiver);
                        next = i.nextItem();
                        continue;
                    }
                    if (!Type.subTypeOf(next.getType(), -1)) continue;
                    if (buf != null && buf.length() > 0) {
                        receiver.characters(buf);
                        buf.setLength(0);
                    }
                    next.copyTo(this.context.getBroker(), receiver);
                    next = i.nextItem();
                }
                if (buf != null && buf.length() > 0) {
                    receiver.characters(buf);
                    buf.setLength(0);
                }
            }
        }
        catch (SAXException e) {
            throw new XPathException(this.getASTNode(), "Encountered SAX exception while processing document constructor: " + ExpressionDumper.dump(this));
        }
        this.context.popDocumentContext();
        DocumentImpl node = builder.getDocument();
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", node);
        }
        return node;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("document {");
        dumper.startIndent();
        this.content.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("document {");
        result.append(this.content.toString());
        result.append("} ");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.content.resetState(postOptimization);
    }
}

