/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.GroupedValueSequence;
import org.exist.xquery.value.GroupedValueSequenceTable;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.OrderedValueSequence;
import org.exist.xquery.value.PreorderedValueSequence;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class LetExpr
extends BindingExpression {
    public LetExpr(XQueryContext context) {
        super(context);
    }

    public void analyze(AnalyzeContextInfo contextInfo, OrderSpec[] orderBy, GroupSpec[] groupBy) throws XPathException {
        if (this.groupVarName != null) {
            LocalVariable groupVar = new LocalVariable(QName.parse(this.context, this.groupVarName, null));
            groupVar.setSequenceType(this.sequenceType);
            this.context.declareVariableBinding(groupVar);
        }
        if (groupBy != null) {
            for (int i = 0; i < groupBy.length; ++i) {
                LocalVariable groupKeyVar = new LocalVariable(QName.parse(this.context, groupBy[i].getKeyVarName(), null));
                groupKeyVar.setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(groupKeyVar);
            }
        }
        LocalVariable mark = this.context.markLocalVariables(false);
        contextInfo.setParent(this);
        this.inputSequence.analyze(contextInfo);
        LocalVariable inVar = new LocalVariable(QName.parse(this.context, this.varName, null));
        inVar.setSequenceType(this.sequenceType);
        this.context.declareVariableBinding(inVar);
        if (this.whereExpr != null) {
            AnalyzeContextInfo newContextInfo = new AnalyzeContextInfo(contextInfo);
            newContextInfo.setFlags(contextInfo.getFlags() | 2 | 4);
            this.whereExpr.analyze(newContextInfo);
        }
        this.context.setContextPosition(0);
        if (this.returnExpr instanceof BindingExpression) {
            ((BindingExpression)this.returnExpr).analyze(contextInfo, orderBy, groupBy);
        } else {
            if (orderBy != null) {
                for (int i = 0; i < orderBy.length; ++i) {
                    orderBy[i].analyze(contextInfo);
                }
            }
            if (groupBy != null) {
                for (int i = 0; i < groupBy.length; ++i) {
                    groupBy[i].analyze(contextInfo);
                }
            }
            this.returnExpr.analyze(contextInfo);
        }
        this.context.popLocalVariables(mark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence eval(Sequence contextSequence, Item contextItem, Sequence resultSequence, GroupedValueSequenceTable groupedSequence) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
            if (resultSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "RESULT SEQUENCE", resultSequence);
            }
        }
        this.context.pushDocumentContext();
        try {
            boolean fastOrderBy;
            Sequence in;
            LocalVariable groupVar = null;
            LocalVariable[] groupKeyVar = null;
            if (this.groupSpecs != null) {
                groupedSequence = new GroupedValueSequenceTable(this.groupSpecs, this.toGroupVarName, this.context);
                groupVar = new LocalVariable(QName.parse(this.context, this.groupVarName, null));
                groupVar.setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(groupVar);
                groupKeyVar = new LocalVariable[this.groupSpecs.length];
                for (int i = 0; i < this.groupSpecs.length; ++i) {
                    groupKeyVar[i] = new LocalVariable(QName.parse(this.context, this.groupSpecs[i].getKeyVarName(), null));
                    groupKeyVar[i].setSequenceType(this.sequenceType);
                    this.context.declareVariableBinding(groupKeyVar[i]);
                }
            }
            LocalVariable mark = this.context.markLocalVariables(false);
            try {
                in = this.inputSequence.eval(contextSequence, null);
                LetExpr.clearContext(this.getExpressionId(), in);
                LocalVariable var = new LocalVariable(QName.parse(this.context, this.varName, null));
                var.setSequenceType(this.sequenceType);
                this.context.declareVariableBinding(var);
                var.setValue(in);
                if (this.sequenceType == null) {
                    var.checkType();
                }
                var.setContextDocs(this.inputSequence.getContextDocSet());
                this.registerUpdateListener(in);
                if (this.whereExpr != null) {
                    Sequence filtered = this.applyWhereExpression(null);
                    if (filtered.isEmpty()) {
                        if (this.context.getProfiler().isEnabled()) {
                            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
                        }
                        Sequence sequence = Sequence.EMPTY_SEQUENCE;
                        return sequence;
                    }
                    if (filtered.getItemType() == 23 && !filtered.effectiveBooleanValue()) {
                        if (this.context.getProfiler().isEnabled()) {
                            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
                        }
                        Sequence sequence = Sequence.EMPTY_SEQUENCE;
                        return sequence;
                    }
                }
                if (fastOrderBy = this.checkOrderSpecs(in)) {
                    in = new PreorderedValueSequence(this.orderSpecs, in.toNodeSet(), this.getExpressionId());
                }
                if (resultSequence == null && this.orderSpecs != null && !fastOrderBy) {
                    resultSequence = new OrderedValueSequence(this.orderSpecs, in.getItemCount());
                }
                if (groupedSequence == null) {
                    if (this.returnExpr instanceof BindingExpression) {
                        if (resultSequence == null) {
                            resultSequence = new ValueSequence();
                        }
                        ((BindingExpression)this.returnExpr).eval(null, null, resultSequence, null);
                    } else {
                        in = this.returnExpr.eval(null);
                        if (resultSequence == null) {
                            resultSequence = in;
                        } else {
                            resultSequence.addAll(in);
                        }
                    }
                } else if (this.returnExpr instanceof BindingExpression) {
                    if (resultSequence == null) {
                        resultSequence = new ValueSequence();
                    }
                    ((BindingExpression)this.returnExpr).eval(null, null, resultSequence, groupedSequence);
                } else {
                    Sequence toGroupSequence = this.context.resolveVariable(groupedSequence.getToGroupVarName()).getValue();
                    groupedSequence.addAll(toGroupSequence);
                }
                if (this.sequenceType != null) {
                    int actualCardinality = var.getValue().isEmpty() ? 1 : (var.getValue().hasMany() ? 4 : 2);
                    if (!Cardinality.checkCardinality(this.sequenceType.getCardinality(), actualCardinality)) {
                        throw new XPathException(this.getASTNode(), "XPTY0004: Invalid cardinality for variable $" + this.varName + ". Expected " + Cardinality.getDescription(this.sequenceType.getCardinality()) + ", got " + Cardinality.getDescription(actualCardinality));
                    }
                    if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1) ? !var.getValue().isEmpty() && !Type.subTypeOf(var.getValue().getItemType(), this.sequenceType.getPrimaryType()) : !var.getValue().isEmpty() && !Type.subTypeOf(var.getValue().getItemType(), this.sequenceType.getPrimaryType())) {
                        throw new XPathException(this.getASTNode(), "XPTY0004: Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(var.getValue().getItemType()));
                    }
                }
            }
            finally {
                this.context.popLocalVariables(mark);
            }
            if (this.groupSpecs != null) {
                Iterator it = groupedSequence.iterate();
                while (it.hasNext()) {
                    Object key = it.next();
                    GroupedValueSequence currentGroup = (GroupedValueSequence)groupedSequence.get(key);
                    this.context.proceed(this);
                    groupVar.setValue(currentGroup);
                    groupVar.checkType();
                    for (int i = 0; i < groupKeyVar.length; ++i) {
                        groupKeyVar[i].setValue(currentGroup.getGroupKey().itemAt(i).toSequence());
                    }
                    Sequence val = this.groupReturnExpr.eval(null);
                    resultSequence.addAll(val);
                }
            }
            if (this.orderSpecs != null && !fastOrderBy) {
                ((OrderedValueSequence)resultSequence).sort();
            }
            LetExpr.clearContext(this.getExpressionId(), in);
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "", resultSequence);
            }
            this.actualReturnType = resultSequence.getItemType();
            Sequence sequence = resultSequence;
            return sequence;
        }
        finally {
            this.context.popDocumentContext();
        }
    }

    public int returnsType() {
        if (this.sequenceType != null) {
            return this.sequenceType.getPrimaryType();
        }
        return this.actualReturnType;
    }

    public void dump(ExpressionDumper dumper) {
        int i;
        dumper.display("let ", this.getASTNode());
        dumper.startIndent();
        dumper.display("$").display(this.varName);
        dumper.display(" := ");
        this.inputSequence.dump(dumper);
        dumper.endIndent();
        if (this.whereExpr != null) {
            dumper.nl().display("where ");
            this.whereExpr.dump(dumper);
        }
        if (this.groupSpecs != null) {
            dumper.display("group ");
            dumper.display("$").display(this.toGroupVarName);
            dumper.display(" as ");
            dumper.display("$").display(this.groupVarName);
            dumper.display(" by ");
            for (i = 0; i < this.groupSpecs.length; ++i) {
                if (i > 0) {
                    dumper.display(", ");
                }
                dumper.display(this.groupSpecs[i].getGroupExpression().toString());
                dumper.display(" as ");
                dumper.display("$").display(this.groupSpecs[i].getKeyVarName());
            }
            dumper.nl();
        }
        if (this.orderSpecs != null) {
            dumper.nl().display("order by ");
            for (i = 0; i < this.orderSpecs.length; ++i) {
                if (i > 0) {
                    dumper.display(", ");
                }
                dumper.display(this.orderSpecs[i].toString());
            }
        }
        if (this.returnExpr instanceof LetExpr) {
            dumper.display(", ");
        } else {
            dumper.nl().display("return ");
        }
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("let ");
        result.append("$").append(this.varName);
        result.append(" := ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        if (this.whereExpr != null) {
            result.append(" where ");
            result.append(this.whereExpr.toString());
        }
        if (this.groupSpecs != null) {
            result.append("group ");
            result.append("$").append(this.toGroupVarName);
            result.append(" as ");
            result.append("$").append(this.groupVarName);
            result.append(" by ");
            for (i = 0; i < this.groupSpecs.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.groupSpecs[i].getGroupExpression().toString());
                result.append(" as ");
                result.append("$").append(this.groupSpecs[i].getKeyVarName());
            }
            result.append(" ");
        }
        if (this.orderSpecs != null) {
            result.append(" order by ");
            for (i = 0; i < this.orderSpecs.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.orderSpecs[i].toString());
            }
        }
        if (this.returnExpr instanceof LetExpr) {
            result.append(", ");
        } else {
            result.append("return ");
        }
        result.append(this.returnExpr.toString());
        return result.toString();
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitLetExpression(this);
    }
}

