/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.NodeSet;
import org.exist.xquery.Dependency;
import org.exist.xquery.EnclosedExpr;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.LogicalOp;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class OpOr
extends LogicalOp {
    public OpOr(XQueryContext context) {
        super(context);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getLength() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Expression left = this.getLeft();
        Expression right = this.getRight();
        if (this.optimize) {
            NodeSet rl = left.eval(contextSequence, null).toNodeSet();
            rl = rl.getContextNodes(this.contextId);
            NodeSet rr = right.eval(contextSequence, null).toNodeSet();
            rr = rr.getContextNodes(this.contextId);
            result = rl.union(rr);
            if (this.getParent() instanceof EnclosedExpr || ((PathExpr)this.getParent()).getParent() == null) {
                result = result.isEmpty() ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        } else {
            boolean ls = left.eval(contextSequence).effectiveBooleanValue();
            if (ls) {
                result = BooleanValue.TRUE;
            } else {
                boolean rs = right.eval(contextSequence).effectiveBooleanValue();
                Sequence sequence = result = ls || rs ? BooleanValue.TRUE : BooleanValue.FALSE;
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visitOrExpr(this);
    }

    public void dump(ExpressionDumper dumper) {
        if (this.getLength() == 0) {
            return;
        }
        dumper.display("(");
        this.getExpression(0).dump(dumper);
        for (int i = 1; i < this.getLength(); ++i) {
            dumper.display(") or (");
            this.getExpression(i).dump(dumper);
        }
        dumper.display(")");
    }

    public String toString() {
        if (this.getLength() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer("(");
        result.append(this.getExpression(0).toString());
        for (int i = 1; i < this.getLength(); ++i) {
            result.append(") or (");
            result.append(this.getExpression(i).toString());
        }
        result.append(")");
        return result.toString();
    }
}

